/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.response;

import java.util.List;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.MessageDisposition;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.ResponseObjectSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ResponseObject<TMessage extends EmailMessage>
extends ServiceObject {
    private Item referenceItem;

    protected ResponseObject(Item referenceItem) throws Exception {
        super(referenceItem.getService());
        referenceItem.throwIfThisIsNew();
        this.referenceItem = referenceItem;
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return ResponseObjectSchema.Instance;
    }

    @Override
    protected void internalLoad(PropertySet propertySet) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void internalDelete(DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) {
        throw new UnsupportedOperationException();
    }

    protected List<Item> internalCreate(FolderId destinationFolderId, MessageDisposition messageDisposition) throws Exception {
        ((ItemId)this.getPropertyBag().getObjectFromPropertyDefinition(ResponseObjectSchema.ReferenceItemId)).assign(this.referenceItem.getId());
        return this.getService().internalCreateResponseObject(this, destinationFolderId, messageDisposition);
    }

    public TMessage save(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return (TMessage)((EmailMessage)this.internalCreate(destinationFolderId, MessageDisposition.SaveOnly).get(0));
    }

    public TMessage save(WellKnownFolderName destinationFolderName) throws Exception {
        return (TMessage)((EmailMessage)this.internalCreate(new FolderId(destinationFolderName), MessageDisposition.SaveOnly).get(0));
    }

    public TMessage save() throws Exception {
        return (TMessage)((EmailMessage)this.internalCreate(null, MessageDisposition.SaveOnly).get(0));
    }

    public void send() throws Exception {
        this.internalCreate(null, MessageDisposition.SendOnly);
    }

    public void sendAndSaveCopy(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        this.internalCreate(destinationFolderId, MessageDisposition.SendAndSaveCopy);
    }

    public void sendAndSaveCopy(WellKnownFolderName destinationFolderName) throws Exception {
        this.internalCreate(new FolderId(destinationFolderName), MessageDisposition.SendAndSaveCopy);
    }

    public void sendAndSaveCopy() throws Exception {
        this.internalCreate(null, MessageDisposition.SendAndSaveCopy);
    }
}

