/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.credential;

import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;

public final class WebCredentials
extends ExchangeCredentials {
    private String domain;
    private String user;
    private String pwd;
    private boolean useDefaultCredentials = true;

    public String getDomain() {
        return this.domain;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public boolean isUseDefaultCredentials() {
        return this.useDefaultCredentials;
    }

    public WebCredentials() {
        this.useDefaultCredentials = true;
        this.user = null;
        this.pwd = null;
        this.domain = null;
    }

    public WebCredentials(String userName, String password, String domain) {
        if (userName == null || password == null) {
            throw new IllegalArgumentException("User name or password can not be null");
        }
        this.domain = domain;
        this.user = userName;
        this.pwd = password;
        this.useDefaultCredentials = false;
    }

    public WebCredentials(String username, String password) {
        this(username, password, "");
    }

    @Override
    public void prepareWebRequest(HttpWebRequest request) {
        if (this.useDefaultCredentials) {
            request.setUseDefaultCredentials(true);
        } else {
            request.setCredentials(this.domain, this.user, this.pwd);
        }
    }
}

