/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.dns;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import microsoft.exchange.webservices.data.core.exception.dns.DnsException;
import microsoft.exchange.webservices.data.dns.DnsRecord;

public class DnsSrvRecord
extends DnsRecord {
    private String target;
    private int priority;
    private int weight;
    private int port;

    public String getNameTarget() {
        return this.target;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    protected void load(String srvRecord) throws DnsException {
        super.load(null);
        StringTokenizer strTokens = new StringTokenizer(srvRecord);
        try {
            while (strTokens.hasMoreTokens()) {
                String target;
                String priority = strTokens.nextToken();
                this.priority = Integer.parseInt(priority);
                String weight = strTokens.nextToken();
                this.weight = Integer.parseInt(weight);
                String port = strTokens.nextToken();
                this.port = Integer.parseInt(port);
                this.target = target = strTokens.nextToken();
            }
        }
        catch (NumberFormatException ne) {
            throw new DnsException("NumberFormatException " + ne.getMessage());
        }
        catch (NoSuchElementException ne) {
            throw new DnsException("NoSuchElementException " + ne.getMessage());
        }
    }
}

