/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.EmailAddressKey;
import microsoft.exchange.webservices.data.core.enumeration.property.MailboxType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.DictionaryEntryProperty;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChangedDelegate;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class EmailAddressEntry
extends DictionaryEntryProperty<EmailAddressKey>
implements IComplexPropertyChangedDelegate {
    private EmailAddress emailAddress;

    protected EmailAddressEntry() {
        super(EmailAddressKey.class);
        this.emailAddress = new EmailAddress();
        this.emailAddress.addOnChangeEvent(this);
    }

    protected EmailAddressEntry(EmailAddressKey key, EmailAddress emailAddress) {
        super(EmailAddressKey.class, key);
        this.emailAddress = emailAddress;
    }

    @Override
    public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        super.readAttributesFromXml(reader);
        this.getEmailAddress().setName(reader.readAttributeValue("Name"));
        this.getEmailAddress().setRoutingType(reader.readAttributeValue("RoutingType"));
        String mailboxTypeString = reader.readAttributeValue("MailboxType");
        if (mailboxTypeString != null && !mailboxTypeString.isEmpty()) {
            this.getEmailAddress().setMailboxType(EwsUtilities.parse(MailboxType.class, mailboxTypeString));
        } else {
            this.getEmailAddress().setMailboxType(null);
        }
    }

    @Override
    public void readTextValueFromXml(EwsServiceXmlReader reader) throws Exception {
        this.getEmailAddress().setAddress(reader.readValue());
    }

    @Override
    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        if (writer.getService().getRequestedServerVersion().ordinal() > ExchangeVersion.Exchange2007_SP1.ordinal()) {
            writer.writeAttributeValue("Name", this.getEmailAddress().getName());
            writer.writeAttributeValue("RoutingType", this.getEmailAddress().getRoutingType());
            if (this.getEmailAddress().getMailboxType() != MailboxType.Unknown) {
                writer.writeAttributeValue("MailboxType", (Object)this.getEmailAddress().getMailboxType());
            }
        }
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeValue(this.getEmailAddress().getAddress(), "EmailAddress");
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(Object value) {
        if (this.canSetFieldValue(this.emailAddress, value)) {
            this.emailAddress = (EmailAddress)value;
        }
    }

    private void emailAddressChanged(ComplexProperty complexProperty) {
        this.changed();
    }

    public void complexPropertyChanged(ComplexProperty complexProperty) {
        this.emailAddressChanged(complexProperty);
    }
}

