/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceObjectPropertyException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class ItemCollection<TItem extends Item>
extends ComplexProperty
implements Iterable<TItem> {
    private static final Log LOG = LogFactory.getLog(ItemCollection.class);
    private List<TItem> items = new ArrayList<TItem>();

    @Override
    public void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, localElementName);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1) continue;
                Item item = (Item)EwsUtilities.createEwsObjectFromXmlElementName(Item.class, reader.getService(), reader.getLocalName());
                if (item == null) {
                    reader.skipCurrentElement();
                    continue;
                }
                try {
                    item.loadFromXml(reader, true);
                }
                catch (ServiceObjectPropertyException e) {
                    LOG.error((Object)e);
                }
                catch (ServiceVersionException e) {
                    LOG.error((Object)e);
                }
                this.items.add(item);
            } while (!reader.isEndElement(XmlNamespace.Types, localElementName));
        } else {
            reader.read();
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public TItem getItem(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new ArrayIndexOutOfBoundsException("index is out of range.");
        }
        return (TItem)((Item)this.items.get(index));
    }

    public Iterator<TItem> getIterator() {
        return this.items.iterator();
    }

    @Override
    public Iterator<TItem> iterator() {
        return this.items.iterator();
    }
}

