/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.ComplexPropertyDefinitionBase;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ICreateComplexPropertyDelegate;
import microsoft.exchange.webservices.data.IOwnedProperty;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.ServiceObject;

class ComplexPropertyDefinition<TComplexProperty extends ComplexProperty>
extends ComplexPropertyDefinitionBase {
    private Class<TComplexProperty> instance;
    private ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate;

    protected ComplexPropertyDefinition(Class<TComplexProperty> cls, String xmlElementName, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, flags, version);
        this.instance = cls;
        EwsUtilities.EwsAssert(propertyCreationDelegate != null, "ComplexPropertyDefinition ctor", "CreateComplexPropertyDelegate cannot be null");
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    protected ComplexPropertyDefinition(Class<TComplexProperty> cls, String xmlElementName, String uri, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, uri, version);
        this.instance = cls;
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    protected ComplexPropertyDefinition(String xmlElementName, String uri, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, uri, version);
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    protected ComplexPropertyDefinition(Class<TComplexProperty> cls, String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, uri, flags, version);
        this.instance = cls;
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    @Override
    protected ComplexProperty createPropertyInstance(ServiceObject owner) {
        TComplexProperty complexProperty = this.propertyCreationDelegate.createComplexProperty();
        if (complexProperty instanceof IOwnedProperty) {
            IOwnedProperty ownedProperty = (IOwnedProperty)complexProperty;
            ownedProperty.setOwner(owner);
        }
        return complexProperty;
    }

    @Override
    public Class getType() {
        return this.instance;
    }
}

