/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.ComplexPropertyDefinition;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ICreateComplexPropertyDelegate;
import microsoft.exchange.webservices.data.PropertyBag;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.XmlNamespace;

class ContainedPropertyDefinition<TComplexProperty extends ComplexProperty>
extends ComplexPropertyDefinition<TComplexProperty> {
    private Class<TComplexProperty> instance;
    private String containedXmlElementName;

    protected ContainedPropertyDefinition(Class<TComplexProperty> cls, String xmlElementName, String uri, String containedXmlElementName, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(cls, xmlElementName, uri, flags, version, propertyCreationDelegate);
        this.containedXmlElementName = containedXmlElementName;
    }

    @Override
    protected void internalLoadFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        reader.readStartElement(XmlNamespace.Types, this.containedXmlElementName);
        super.internalLoadFromXml(reader, propertyBag);
        reader.readEndElementIfNecessary(XmlNamespace.Types, this.containedXmlElementName);
    }

    @Override
    protected void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        Object o = propertyBag.getObjectFromPropertyDefinition(this);
        if (o instanceof ComplexProperty) {
            ComplexProperty complexProperty = (ComplexProperty)o;
            writer.writeStartElement(XmlNamespace.Types, this.getXmlElement());
            complexProperty.writeToXml(writer, this.containedXmlElementName);
            writer.writeEndElement();
        }
    }
}

