/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.ConversationActionType;
import microsoft.exchange.webservices.data.ConversationId;
import microsoft.exchange.webservices.data.DeleteMode;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FolderIdWrapper;
import microsoft.exchange.webservices.data.StringList;
import microsoft.exchange.webservices.data.XmlNamespace;

class ConversationAction {
    private ConversationActionType action;
    private ConversationId conversationId;
    private boolean processRightAway;
    private boolean enableAlwaysDelete;
    private StringList categories;
    private FolderIdWrapper moveFolderId;
    private FolderIdWrapper contextFolderId;
    private DeleteMode deleteType;
    private Boolean isRead;
    private Date conversationLastSyncTime;

    ConversationAction() {
    }

    protected ConversationActionType getAction() {
        return this.action;
    }

    protected void setAction(ConversationActionType value) {
        this.action = value;
    }

    protected ConversationId getConversationId() {
        return this.conversationId;
    }

    protected void setConversationId(ConversationId value) {
        this.conversationId = value;
    }

    protected boolean getProcessRightAway() {
        return this.processRightAway;
    }

    protected void setProcessRightAway(boolean value) {
        this.processRightAway = value;
    }

    protected StringList getCategories() {
        return this.categories;
    }

    protected void setCategories(StringList value) {
        this.categories = value;
    }

    protected boolean getEnableAlwaysDelete() {
        return this.enableAlwaysDelete;
    }

    protected void setEnableAlwaysDelete(boolean value) {
        this.enableAlwaysDelete = value;
    }

    protected Boolean getIsRead() {
        return this.isRead;
    }

    protected void setIsRead(Boolean value) {
        this.isRead = value;
    }

    protected DeleteMode getDeleteType() {
        return this.deleteType;
    }

    protected void setDeleteType(DeleteMode value) {
        this.deleteType = value;
    }

    protected Date getConversationLastSyncTime() {
        return this.conversationLastSyncTime;
    }

    protected void setConversationLastSyncTime(Date value) {
        this.conversationLastSyncTime = value;
    }

    protected FolderIdWrapper getContextFolderId() {
        return this.contextFolderId;
    }

    protected void setContextFolderId(FolderIdWrapper value) {
        this.contextFolderId = value;
    }

    protected FolderIdWrapper getDestinationFolderId() {
        return this.moveFolderId;
    }

    protected void setDestinationFolderId(FolderIdWrapper value) {
        this.moveFolderId = value;
    }

    protected String getXmlElementName() {
        return "ApplyConversationAction";
    }

    protected void validate() throws Exception {
        EwsUtilities.validateParam(this.conversationId, "conversationId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, "ConversationAction");
        try {
            String actionValue = null;
            if (this.getAction() == ConversationActionType.AlwaysCategorize) {
                actionValue = "AlwaysCategorize";
            } else if (this.getAction() == ConversationActionType.AlwaysDelete) {
                actionValue = "AlwaysDelete";
            } else if (this.getAction() == ConversationActionType.AlwaysMove) {
                actionValue = "AlwaysMove";
            } else if (this.getAction() == ConversationActionType.Delete) {
                actionValue = "Delete";
            } else if (this.getAction() == ConversationActionType.Copy) {
                actionValue = "Copy";
            } else if (this.getAction() == ConversationActionType.Move) {
                actionValue = "Move";
            } else if (this.getAction() == ConversationActionType.SetReadState) {
                actionValue = "SetReadState";
            } else {
                throw new ArgumentException("ConversationAction");
            }
            writer.writeElementValue(XmlNamespace.Types, "Action", actionValue);
            this.getConversationId().writeToXml(writer, XmlNamespace.Types, "ConversationId");
            if (this.getAction() == ConversationActionType.AlwaysCategorize || this.getAction() == ConversationActionType.AlwaysDelete || this.getAction() == ConversationActionType.AlwaysMove) {
                writer.writeElementValue(XmlNamespace.Types, "ProcessRightAway", EwsUtilities.boolToXSBool(this.getProcessRightAway()));
            }
            if (this.getAction() == ConversationActionType.AlwaysCategorize) {
                if (this.getCategories() != null && this.getCategories().getSize() > 0) {
                    this.getCategories().writeToXml(writer, XmlNamespace.Types, "Categories");
                }
            } else if (this.getAction() == ConversationActionType.AlwaysDelete) {
                writer.writeElementValue(XmlNamespace.Types, "EnableAlwaysDelete", EwsUtilities.boolToXSBool(this.getEnableAlwaysDelete()));
            } else if (this.getAction() == ConversationActionType.AlwaysMove) {
                if (this.getDestinationFolderId() != null) {
                    writer.writeStartElement(XmlNamespace.Types, "DestinationFolderId");
                    this.getDestinationFolderId().writeToXml(writer);
                    writer.writeEndElement();
                }
            } else {
                if (this.getContextFolderId() != null) {
                    writer.writeStartElement(XmlNamespace.Types, "ContextFolderId");
                    this.getContextFolderId().writeToXml(writer);
                    writer.writeEndElement();
                }
                if (this.getConversationLastSyncTime() != null) {
                    writer.writeElementValue(XmlNamespace.Types, "ConversationLastSyncTime", this.getConversationLastSyncTime());
                }
                if (this.getAction() == ConversationActionType.Copy) {
                    EwsUtilities.EwsAssert(this.getDestinationFolderId() != null, "ApplyconversationActionRequest", "DestinationFolderId should be set when performing copy action");
                    writer.writeStartElement(XmlNamespace.Types, "DestinationFolderId");
                    this.getDestinationFolderId().writeToXml(writer);
                    writer.writeEndElement();
                } else if (this.getAction() == ConversationActionType.Move) {
                    EwsUtilities.EwsAssert(this.getDestinationFolderId() != null, "ApplyconversationActionRequest", "DestinationFolderId should be set when performing move action");
                    writer.writeStartElement(XmlNamespace.Types, "DestinationFolderId");
                    this.getDestinationFolderId().writeToXml(writer);
                    writer.writeEndElement();
                } else if (this.getAction() == ConversationActionType.Delete) {
                    EwsUtilities.EwsAssert(this.getDeleteType() != null, "ApplyconversationActionRequest", "DeleteType should be specified when deleting a conversation.");
                    writer.writeElementValue(XmlNamespace.Types, "DeleteType", (Object)this.getDeleteType());
                } else if (this.getAction() == ConversationActionType.SetReadState) {
                    EwsUtilities.EwsAssert(this.getIsRead() != null, "ApplyconversationActionRequest", "IsRead should be specified when marking/unmarking a conversation as read.");
                    writer.writeElementValue(XmlNamespace.Types, "IsRead", this.getIsRead());
                }
            }
        }
        finally {
            writer.writeEndElement();
        }
    }
}

