/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.Attachment;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class DeleteAttachmentResponse
extends ServiceResponse {
    private Attachment attachment;

    protected DeleteAttachmentResponse(Attachment attachment) {
        EwsUtilities.EwsAssert(attachment != null, "DeleteAttachmentResponse.ctor", "attachment is null");
        this.attachment = attachment;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws ServiceLocalException, Exception {
        super.readElementsFromXml(reader);
        reader.readStartElement(XmlNamespace.Messages, "RootItemId");
        String changeKey = reader.readAttributeValue("RootItemChangeKey");
        if (null != changeKey && !changeKey.isEmpty()) {
            this.attachment.getOwner().getRootItemId().setChangeKey(changeKey);
        }
        reader.readEndElement(XmlNamespace.Messages, "RootItemId");
    }

    protected Attachment getAttachment() {
        return this.attachment;
    }
}

