/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.UserConfiguration;
import microsoft.exchange.webservices.data.XmlNamespace;

class DeleteUserConfigurationRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private String name;
    private FolderId parentFolderId;

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.name, "name");
        EwsUtilities.validateParam(this.parentFolderId, "parentFolderId");
        this.getParentFolderId().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "DeleteUserConfiguration";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "DeleteUserConfigurationResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "DeleteUserConfigurationResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        UserConfiguration.writeUserConfigurationNameToXml(writer, XmlNamespace.Messages, this.name, this.parentFolderId);
    }

    protected DeleteUserConfigurationRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    protected void setParentFolderId(FolderId parentFolderId) {
        this.parentFolderId = parentFolderId;
    }
}

