/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import microsoft.exchange.webservices.data.AccountIsLockedException;
import microsoft.exchange.webservices.data.AddDelegateRequest;
import microsoft.exchange.webservices.data.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.AlternateIdBase;
import microsoft.exchange.webservices.data.ApplyConversationActionRequest;
import microsoft.exchange.webservices.data.Appointment;
import microsoft.exchange.webservices.data.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.Attachment;
import microsoft.exchange.webservices.data.AttendeeInfo;
import microsoft.exchange.webservices.data.AutodiscoverLocalException;
import microsoft.exchange.webservices.data.AutodiscoverService;
import microsoft.exchange.webservices.data.AvailabilityData;
import microsoft.exchange.webservices.data.AvailabilityOptions;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.CalendarView;
import microsoft.exchange.webservices.data.ChangeCollection;
import microsoft.exchange.webservices.data.ConflictResolutionMode;
import microsoft.exchange.webservices.data.Conversation;
import microsoft.exchange.webservices.data.ConversationAction;
import microsoft.exchange.webservices.data.ConversationActionType;
import microsoft.exchange.webservices.data.ConversationId;
import microsoft.exchange.webservices.data.ConversationIndexedItemView;
import microsoft.exchange.webservices.data.ConvertIdRequest;
import microsoft.exchange.webservices.data.ConvertIdResponse;
import microsoft.exchange.webservices.data.CopyFolderRequest;
import microsoft.exchange.webservices.data.CopyItemRequest;
import microsoft.exchange.webservices.data.CreateAttachmentRequest;
import microsoft.exchange.webservices.data.CreateAttachmentResponse;
import microsoft.exchange.webservices.data.CreateFolderRequest;
import microsoft.exchange.webservices.data.CreateItemRequest;
import microsoft.exchange.webservices.data.CreateResponseObjectRequest;
import microsoft.exchange.webservices.data.CreateResponseObjectResponse;
import microsoft.exchange.webservices.data.CreateUserConfigurationRequest;
import microsoft.exchange.webservices.data.DelegateInformation;
import microsoft.exchange.webservices.data.DelegateManagementResponse;
import microsoft.exchange.webservices.data.DelegateUser;
import microsoft.exchange.webservices.data.DelegateUserResponse;
import microsoft.exchange.webservices.data.DeleteAttachmentRequest;
import microsoft.exchange.webservices.data.DeleteAttachmentResponse;
import microsoft.exchange.webservices.data.DeleteFolderRequest;
import microsoft.exchange.webservices.data.DeleteItemRequest;
import microsoft.exchange.webservices.data.DeleteMode;
import microsoft.exchange.webservices.data.DeleteUserConfigurationRequest;
import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EmailAddressCollection;
import microsoft.exchange.webservices.data.EmptyFolderRequest;
import microsoft.exchange.webservices.data.EventType;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeServiceBase;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ExecuteDiagnosticMethodRequest;
import microsoft.exchange.webservices.data.ExecuteDiagnosticMethodResponse;
import microsoft.exchange.webservices.data.ExpandGroupRequest;
import microsoft.exchange.webservices.data.ExpandGroupResponse;
import microsoft.exchange.webservices.data.ExpandGroupResults;
import microsoft.exchange.webservices.data.FindConversationRequest;
import microsoft.exchange.webservices.data.FindFolderRequest;
import microsoft.exchange.webservices.data.FindFolderResponse;
import microsoft.exchange.webservices.data.FindFoldersResults;
import microsoft.exchange.webservices.data.FindItemRequest;
import microsoft.exchange.webservices.data.FindItemResponse;
import microsoft.exchange.webservices.data.FindItemsResults;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.FolderChange;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.FolderIdWrapper;
import microsoft.exchange.webservices.data.FolderView;
import microsoft.exchange.webservices.data.GetAttachmentRequest;
import microsoft.exchange.webservices.data.GetAttachmentResponse;
import microsoft.exchange.webservices.data.GetDelegateRequest;
import microsoft.exchange.webservices.data.GetDelegateResponse;
import microsoft.exchange.webservices.data.GetEventsRequest;
import microsoft.exchange.webservices.data.GetEventsResponse;
import microsoft.exchange.webservices.data.GetEventsResults;
import microsoft.exchange.webservices.data.GetFolderRequest;
import microsoft.exchange.webservices.data.GetFolderRequestForLoad;
import microsoft.exchange.webservices.data.GetFolderResponse;
import microsoft.exchange.webservices.data.GetInboxRulesRequest;
import microsoft.exchange.webservices.data.GetItemRequest;
import microsoft.exchange.webservices.data.GetItemRequestForLoad;
import microsoft.exchange.webservices.data.GetItemResponse;
import microsoft.exchange.webservices.data.GetRoomListsRequest;
import microsoft.exchange.webservices.data.GetRoomsRequest;
import microsoft.exchange.webservices.data.GetUserAvailabilityRequest;
import microsoft.exchange.webservices.data.GetUserAvailabilityResults;
import microsoft.exchange.webservices.data.GetUserConfigurationRequest;
import microsoft.exchange.webservices.data.GetUserConfigurationResponse;
import microsoft.exchange.webservices.data.GetUserOofSettingsRequest;
import microsoft.exchange.webservices.data.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.GroupedFindItemsResults;
import microsoft.exchange.webservices.data.Grouping;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.IAutodiscoverRedirectionUrl;
import microsoft.exchange.webservices.data.IFileAttachmentContentHandler;
import microsoft.exchange.webservices.data.IPredicate;
import microsoft.exchange.webservices.data.IdFormat;
import microsoft.exchange.webservices.data.ImpersonatedUserId;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemChange;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.ItemView;
import microsoft.exchange.webservices.data.Mailbox;
import microsoft.exchange.webservices.data.MeetingRequestsDeliveryScope;
import microsoft.exchange.webservices.data.MessageDisposition;
import microsoft.exchange.webservices.data.MoveCopyFolderResponse;
import microsoft.exchange.webservices.data.MoveCopyItemResponse;
import microsoft.exchange.webservices.data.MoveFolderRequest;
import microsoft.exchange.webservices.data.MoveItemRequest;
import microsoft.exchange.webservices.data.NameResolutionCollection;
import microsoft.exchange.webservices.data.OofSettings;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.PullSubscription;
import microsoft.exchange.webservices.data.PushSubscription;
import microsoft.exchange.webservices.data.RemoveDelegateRequest;
import microsoft.exchange.webservices.data.ResolveNameSearchLocation;
import microsoft.exchange.webservices.data.ResolveNamesRequest;
import microsoft.exchange.webservices.data.ResolveNamesResponse;
import microsoft.exchange.webservices.data.RuleCollection;
import microsoft.exchange.webservices.data.RuleOperation;
import microsoft.exchange.webservices.data.SearchFilter;
import microsoft.exchange.webservices.data.SendCancellationsMode;
import microsoft.exchange.webservices.data.SendInvitationsMode;
import microsoft.exchange.webservices.data.SendInvitationsOrCancellationsMode;
import microsoft.exchange.webservices.data.SendItemRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceRemoteException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceResponseCollection;
import microsoft.exchange.webservices.data.ServiceResponseException;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.SetUserOofSettingsRequest;
import microsoft.exchange.webservices.data.StreamingSubscription;
import microsoft.exchange.webservices.data.StringList;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.SubscribeResponse;
import microsoft.exchange.webservices.data.SubscribeToPullNotificationsRequest;
import microsoft.exchange.webservices.data.SubscribeToPushNotificationsRequest;
import microsoft.exchange.webservices.data.SubscribeToStreamingNotificationsRequest;
import microsoft.exchange.webservices.data.SyncFolderHierarchyRequest;
import microsoft.exchange.webservices.data.SyncFolderHierarchyResponse;
import microsoft.exchange.webservices.data.SyncFolderItemsRequest;
import microsoft.exchange.webservices.data.SyncFolderItemsResponse;
import microsoft.exchange.webservices.data.SyncFolderItemsScope;
import microsoft.exchange.webservices.data.TimeWindow;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.TraceFlags;
import microsoft.exchange.webservices.data.UnifiedMessaging;
import microsoft.exchange.webservices.data.UnsubscribeRequest;
import microsoft.exchange.webservices.data.UpdateDelegateRequest;
import microsoft.exchange.webservices.data.UpdateFolderRequest;
import microsoft.exchange.webservices.data.UpdateInboxRulesRequest;
import microsoft.exchange.webservices.data.UpdateItemRequest;
import microsoft.exchange.webservices.data.UpdateItemResponse;
import microsoft.exchange.webservices.data.UpdateUserConfigurationRequest;
import microsoft.exchange.webservices.data.UserConfiguration;
import microsoft.exchange.webservices.data.UserConfigurationProperties;
import microsoft.exchange.webservices.data.UserId;
import microsoft.exchange.webservices.data.UserSettingName;
import microsoft.exchange.webservices.data.ViewBase;
import microsoft.exchange.webservices.data.WellKnownFolderName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class ExchangeService
extends ExchangeServiceBase
implements IAutodiscoverRedirectionUrl {
    private URI url;
    private Locale preferredCulture;
    private ImpersonatedUserId impersonatedUserId;
    private IFileAttachmentContentHandler fileAttachmentContentHandler;
    private UnifiedMessaging unifiedMessaging;
    private boolean enableScpLookup = true;
    private boolean exchange2007CompatibilityMode;

    protected List<Item> internalCreateResponseObject(ServiceObject responseObject, FolderId parentFolderId, MessageDisposition messageDisposition) throws Exception {
        CreateResponseObjectRequest request = new CreateResponseObjectRequest(this, ServiceErrorHandling.ThrowOnError);
        ArrayList<ServiceObject> serviceList = new ArrayList<ServiceObject>();
        serviceList.add(responseObject);
        request.setParentFolderId(parentFolderId);
        request.setItems(serviceList);
        request.setMessageDisposition(messageDisposition);
        ServiceResponseCollection responses = request.execute();
        return ((CreateResponseObjectResponse)responses.getResponseAtIndex(0)).getItems();
    }

    protected void createFolder(Folder folder, FolderId parentFolderId) throws Exception {
        CreateFolderRequest request = new CreateFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        ArrayList<Folder> folArry = new ArrayList<Folder>();
        folArry.add(folder);
        request.setFolders(folArry);
        request.setParentFolderId(parentFolderId);
        request.execute();
    }

    protected void updateFolder(Folder folder) throws Exception {
        UpdateFolderRequest request = new UpdateFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.getFolders().add(folder);
        request.execute();
    }

    protected Folder copyFolder(FolderId folderId, FolderId destinationFolderId) throws Exception {
        CopyFolderRequest request = new CopyFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.setDestinationFolderId(destinationFolderId);
        request.getFolderIds().add(folderId);
        ServiceResponseCollection responses = request.execute();
        return ((MoveCopyFolderResponse)responses.getResponseAtIndex(0)).getFolder();
    }

    protected Folder moveFolder(FolderId folderId, FolderId destinationFolderId) throws Exception {
        MoveFolderRequest request = new MoveFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.setDestinationFolderId(destinationFolderId);
        request.getFolderIds().add(folderId);
        ServiceResponseCollection responses = request.execute();
        return ((MoveCopyFolderResponse)responses.getResponseAtIndex(0)).getFolder();
    }

    private ServiceResponseCollection<FindFolderResponse> internalFindFolders(Iterable<FolderId> parentFolderIds, SearchFilter searchFilter, FolderView view, ServiceErrorHandling errorHandlingMode) throws Exception {
        FindFolderRequest request = new FindFolderRequest(this, errorHandlingMode);
        request.getParentFolderIds().addRangeFolderId(parentFolderIds);
        request.setSearchFilter(searchFilter);
        request.setView(view);
        return request.execute();
    }

    public FindFoldersResults findFolders(FolderId parentFolderId, SearchFilter searchFilter, FolderView view) throws Exception {
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        EwsUtilities.validateParam(view, "view");
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection<FindFolderResponse> responses = this.internalFindFolders(folderIdArray, searchFilter, view, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindFoldersResults findFolders(FolderId parentFolderId, FolderView view) throws Exception {
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        EwsUtilities.validateParam(view, "view");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection<FindFolderResponse> responses = this.internalFindFolders(folderIdArray, null, view, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindFoldersResults findFolders(WellKnownFolderName parentFolderName, SearchFilter searchFilter, FolderView view) throws Exception {
        return this.findFolders(new FolderId(parentFolderName), searchFilter, view);
    }

    public FindFoldersResults findFolders(WellKnownFolderName parentFolderName, FolderView view) throws Exception {
        return this.findFolders(new FolderId(parentFolderName), view);
    }

    protected void loadPropertiesForFolder(Folder folder, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParam(folder, "folder");
        EwsUtilities.validateParam(propertySet, "propertySet");
        GetFolderRequestForLoad request = new GetFolderRequestForLoad(this, ServiceErrorHandling.ThrowOnError);
        request.getFolderIds().add(folder);
        request.setPropertySet(propertySet);
        request.execute();
    }

    protected Folder bindToFolder(FolderId folderId, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        EwsUtilities.validateParam(propertySet, "propertySet");
        GetFolderRequest request = new GetFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.getFolderIds().add(folderId);
        request.setPropertySet(propertySet);
        ServiceResponseCollection responses = request.execute();
        return ((GetFolderResponse)responses.getResponseAtIndex(0)).getFolder();
    }

    protected <TFolder extends Folder> TFolder bindToFolder(Class<TFolder> cls, FolderId folderId, PropertySet propertySet) throws Exception {
        Folder result = this.bindToFolder(folderId, propertySet);
        if (result instanceof Folder) {
            return (TFolder)result;
        }
        throw new ServiceLocalException(String.format("%s,%s,%s", Strings.FolderTypeNotCompatible, result.getClass().getName(), cls.getName()));
    }

    protected void deleteFolder(FolderId folderId, DeleteMode deleteMode) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        DeleteFolderRequest request = new DeleteFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.getFolderIds().add(folderId);
        request.setDeleteMode(deleteMode);
        request.execute();
    }

    protected void emptyFolder(FolderId folderId, DeleteMode deleteMode, boolean deleteSubFolders) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        EmptyFolderRequest request = new EmptyFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.getFolderIds().add(folderId);
        request.setDeleteMode(deleteMode);
        request.setDeleteSubFolders(deleteSubFolders);
        request.execute();
    }

    private ServiceResponseCollection<ServiceResponse> internalCreateItems(Collection<Item> items, FolderId parentFolderId, MessageDisposition messageDisposition, SendInvitationsMode sendInvitationsMode, ServiceErrorHandling errorHandling) throws Exception {
        CreateItemRequest request = new CreateItemRequest(this, errorHandling);
        request.setParentFolderId(parentFolderId);
        request.setItems(items);
        request.setMessageDisposition(messageDisposition);
        request.setSendInvitationsMode(sendInvitationsMode);
        return request.execute();
    }

    public ServiceResponseCollection<ServiceResponse> createItems(Collection<Item> items, FolderId parentFolderId, MessageDisposition messageDisposition, SendInvitationsMode sendInvitationsMode) throws Exception {
        if (!EwsUtilities.trueForAll(items, new IPredicate<Item>(){

            @Override
            public boolean predicate(Item obj) throws ServiceLocalException {
                return obj.isNew();
            }
        })) {
            throw new ServiceValidationException(Strings.CreateItemsDoesNotHandleExistingItems);
        }
        if (!EwsUtilities.trueForAll(items, new IPredicate<Item>(){

            @Override
            public boolean predicate(Item obj) throws ServiceLocalException {
                return !obj.hasUnprocessedAttachmentChanges();
            }
        })) {
            throw new ServiceValidationException(Strings.CreateItemsDoesNotAllowAttachments);
        }
        return this.internalCreateItems(items, parentFolderId, messageDisposition, sendInvitationsMode, ServiceErrorHandling.ReturnErrors);
    }

    protected void createItem(Item item, FolderId parentFolderId, MessageDisposition messageDisposition, SendInvitationsMode sendInvitationsMode) throws Exception {
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(item);
        this.internalCreateItems(items, parentFolderId, messageDisposition, sendInvitationsMode, ServiceErrorHandling.ThrowOnError);
    }

    private ServiceResponseCollection<UpdateItemResponse> internalUpdateItems(Iterable<Item> items, FolderId savedItemsDestinationFolderId, ConflictResolutionMode conflictResolution, MessageDisposition messageDisposition, SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode, ServiceErrorHandling errorHandling) throws Exception {
        UpdateItemRequest request = new UpdateItemRequest(this, errorHandling);
        request.getItems().addAll((Collection)items);
        request.setSavedItemsDestinationFolder(savedItemsDestinationFolderId);
        request.setMessageDisposition(messageDisposition);
        request.setConflictResolutionMode(conflictResolution);
        request.setSendInvitationsOrCancellationsMode(sendInvitationsOrCancellationsMode);
        return request.execute();
    }

    public ServiceResponseCollection<UpdateItemResponse> updateItems(Iterable<Item> items, FolderId savedItemsDestinationFolderId, ConflictResolutionMode conflictResolution, MessageDisposition messageDisposition, SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode) throws Exception {
        if (!EwsUtilities.trueForAll(items, new IPredicate<Item>(){

            @Override
            public boolean predicate(Item obj) throws ServiceLocalException {
                return !obj.isNew() && obj.isDirty();
            }
        })) {
            throw new ServiceValidationException(Strings.UpdateItemsDoesNotSupportNewOrUnchangedItems);
        }
        if (!EwsUtilities.trueForAll(items, new IPredicate<Item>(){

            @Override
            public boolean predicate(Item obj) throws ServiceLocalException {
                return !obj.hasUnprocessedAttachmentChanges();
            }
        })) {
            throw new ServiceValidationException(Strings.UpdateItemsDoesNotAllowAttachments);
        }
        return this.internalUpdateItems(items, savedItemsDestinationFolderId, conflictResolution, messageDisposition, sendInvitationsOrCancellationsMode, ServiceErrorHandling.ReturnErrors);
    }

    protected Item updateItem(Item item, FolderId savedItemsDestinationFolderId, ConflictResolutionMode conflictResolution, MessageDisposition messageDisposition, SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode) throws Exception {
        ArrayList<Item> itemIdArray = new ArrayList<Item>();
        itemIdArray.add(item);
        ServiceResponseCollection<UpdateItemResponse> responses = this.internalUpdateItems(itemIdArray, savedItemsDestinationFolderId, conflictResolution, messageDisposition, sendInvitationsOrCancellationsMode, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getReturnedItem();
    }

    protected void sendItem(Item item, FolderId savedCopyDestinationFolderId) throws Exception {
        SendItemRequest request = new SendItemRequest(this, ServiceErrorHandling.ThrowOnError);
        ArrayList<Item> itemIdArray = new ArrayList<Item>();
        itemIdArray.add(item);
        request.setItems(itemIdArray);
        request.setSavedCopyDestinationFolderId(savedCopyDestinationFolderId);
        request.execute();
    }

    private ServiceResponseCollection<MoveCopyItemResponse> internalCopyItems(Iterable<ItemId> itemIds, FolderId destinationFolderId, Boolean returnNewItemIds, ServiceErrorHandling errorHandling) throws Exception {
        CopyItemRequest request = new CopyItemRequest(this, errorHandling);
        request.getItemIds().addRange(itemIds);
        request.setDestinationFolderId(destinationFolderId);
        request.setReturnNewItemIds(returnNewItemIds);
        return request.execute();
    }

    public ServiceResponseCollection<MoveCopyItemResponse> copyItems(Iterable<ItemId> itemIds, FolderId destinationFolderId) throws Exception {
        return this.internalCopyItems(itemIds, destinationFolderId, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<MoveCopyItemResponse> copyItems(Iterable<ItemId> itemIds, FolderId destinationFolderId, boolean returnNewItemIds) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "CopyItems");
        return this.internalCopyItems(itemIds, destinationFolderId, returnNewItemIds, ServiceErrorHandling.ReturnErrors);
    }

    protected Item copyItem(ItemId itemId, FolderId destinationFolderId) throws IndexOutOfBoundsException, Exception {
        ArrayList<ItemId> itemIdArray = new ArrayList<ItemId>();
        itemIdArray.add(itemId);
        return this.internalCopyItems(itemIdArray, destinationFolderId, null, ServiceErrorHandling.ThrowOnError).getResponseAtIndex(0).getItem();
    }

    private ServiceResponseCollection<MoveCopyItemResponse> internalMoveItems(Iterable<ItemId> itemIds, FolderId destinationFolderId, Boolean returnNewItemIds, ServiceErrorHandling errorHandling) throws Exception {
        MoveItemRequest request = new MoveItemRequest(this, errorHandling);
        request.getItemIds().addRange(itemIds);
        request.setDestinationFolderId(destinationFolderId);
        request.setReturnNewItemIds(returnNewItemIds);
        return request.execute();
    }

    public ServiceResponseCollection<MoveCopyItemResponse> moveItems(Iterable<ItemId> itemIds, FolderId destinationFolderId) throws Exception {
        return this.internalMoveItems(itemIds, destinationFolderId, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<MoveCopyItemResponse> moveItems(Iterable<ItemId> itemIds, FolderId destinationFolderId, boolean returnNewItemIds) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "MoveItems");
        return this.internalMoveItems(itemIds, destinationFolderId, returnNewItemIds, ServiceErrorHandling.ReturnErrors);
    }

    protected Item moveItem(ItemId itemId, FolderId destinationFolderId) throws IndexOutOfBoundsException, Exception {
        ArrayList<ItemId> itemIdArray = new ArrayList<ItemId>();
        itemIdArray.add(itemId);
        return this.internalMoveItems(itemIdArray, destinationFolderId, null, ServiceErrorHandling.ThrowOnError).getResponseAtIndex(0).getItem();
    }

    protected <TItem extends Item> ServiceResponseCollection<FindItemResponse<TItem>> findItems(Iterable<FolderId> parentFolderIds, SearchFilter searchFilter, String queryString, ViewBase view, Grouping groupBy, ServiceErrorHandling errorHandlingMode) throws Exception {
        EwsUtilities.validateParamCollection(parentFolderIds.iterator(), "parentFolderIds");
        EwsUtilities.validateParam(view, "view");
        EwsUtilities.validateParamAllowNull(groupBy, "groupBy");
        EwsUtilities.validateParamAllowNull(queryString, "queryString");
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        FindItemRequest request = new FindItemRequest(this, errorHandlingMode);
        request.getParentFolderIds().addRangeFolderId(parentFolderIds);
        request.setSearchFilter(searchFilter);
        request.setQueryString(queryString);
        request.setView(view);
        request.setGroupBy(groupBy);
        return request.execute();
    }

    public FindItemsResults<Item> findItems(FolderId parentFolderId, String queryString, ItemView view) throws Exception {
        EwsUtilities.validateParamAllowNull(queryString, "queryString");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, null, queryString, view, null, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Item> findItems(FolderId parentFolderId, SearchFilter searchFilter, ItemView view) throws Exception {
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, searchFilter, null, view, null, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Item> findItems(FolderId parentFolderId, ItemView view) throws Exception {
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, null, null, view, null, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, String queryString, ItemView view) throws Exception {
        return this.findItems(new FolderId(parentFolderName), queryString, view);
    }

    public FindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, SearchFilter searchFilter, ItemView view) throws Exception {
        return this.findItems(new FolderId(parentFolderName), searchFilter, view);
    }

    public FindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, ItemView view) throws Exception {
        return this.findItems(new FolderId(parentFolderName), (SearchFilter)null, view);
    }

    public GroupedFindItemsResults<Item> findItems(FolderId parentFolderId, String queryString, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        EwsUtilities.validateParamAllowNull(queryString, "queryString");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, null, queryString, view, groupBy, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getGroupedFindResults();
    }

    public GroupedFindItemsResults<Item> findItems(FolderId parentFolderId, SearchFilter searchFilter, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, searchFilter, null, view, groupBy, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getGroupedFindResults();
    }

    public GroupedFindItemsResults<Item> findItems(FolderId parentFolderId, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, null, null, view, groupBy, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getGroupedFindResults();
    }

    protected <TItem extends Item> ServiceResponseCollection<FindItemResponse<TItem>> findItems(Class<TItem> cls, FolderId parentFolderId, SearchFilter searchFilter, ViewBase view, Grouping groupBy) throws Exception {
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        return this.findItems(folderIdArray, searchFilter, null, view, groupBy, ServiceErrorHandling.ThrowOnError);
    }

    public GroupedFindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, String queryString, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        return this.findItems(new FolderId(parentFolderName), queryString, view, groupBy);
    }

    public GroupedFindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, SearchFilter searchFilter, ItemView view, Grouping groupBy) throws Exception {
        return this.findItems(new FolderId(parentFolderName), searchFilter, view, groupBy);
    }

    public FindItemsResults<Appointment> findAppointments(FolderId parentFolderId, CalendarView calendarView) throws Exception {
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection response = this.findItems(folderIdArray, null, null, calendarView, null, ServiceErrorHandling.ThrowOnError);
        return response.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Appointment> findAppointments(WellKnownFolderName parentFolderName, CalendarView calendarView) throws Exception {
        return this.findAppointments(new FolderId(parentFolderName), calendarView);
    }

    public ServiceResponseCollection<ServiceResponse> loadPropertiesForItems(Iterable<Item> items, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParamCollection(items.iterator(), "items");
        EwsUtilities.validateParam(propertySet, "propertySet");
        return this.internalLoadPropertiesForItems(items, propertySet, ServiceErrorHandling.ReturnErrors);
    }

    ServiceResponseCollection<ServiceResponse> internalLoadPropertiesForItems(Iterable<Item> items, PropertySet propertySet, ServiceErrorHandling errorHandling) throws Exception {
        GetItemRequestForLoad request = new GetItemRequestForLoad(this, errorHandling);
        request.getItemIds().addRangeItem(items);
        request.setPropertySet(propertySet);
        return request.execute();
    }

    private ServiceResponseCollection<GetItemResponse> internalBindToItems(Iterable<ItemId> itemIds, PropertySet propertySet, ServiceErrorHandling errorHandling) throws Exception {
        GetItemRequest request = new GetItemRequest(this, errorHandling);
        request.getItemIds().addRange(itemIds);
        request.setPropertySet(propertySet);
        return request.execute();
    }

    public ServiceResponseCollection<GetItemResponse> bindToItems(Iterable<ItemId> itemIds, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParamCollection(itemIds.iterator(), "itemIds");
        EwsUtilities.validateParam(propertySet, "propertySet");
        return this.internalBindToItems(itemIds, propertySet, ServiceErrorHandling.ReturnErrors);
    }

    protected Item bindToItem(ItemId itemId, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParam(itemId, "itemId");
        EwsUtilities.validateParam(propertySet, "propertySet");
        ArrayList<ItemId> itmLst = new ArrayList<ItemId>();
        itmLst.add(itemId);
        ServiceResponseCollection<GetItemResponse> responses = this.internalBindToItems(itmLst, propertySet, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getItem();
    }

    protected <TItem extends Item> TItem bindToItem(Class<TItem> c, ItemId itemId, PropertySet propertySet) throws Exception {
        Item result = this.bindToItem(itemId, propertySet);
        if (result instanceof Item) {
            return (TItem)result;
        }
        throw new ServiceLocalException(String.format(Strings.ItemTypeNotCompatible, result.getClass().getName(), c.getName()));
    }

    private ServiceResponseCollection<ServiceResponse> internalDeleteItems(Iterable<ItemId> itemIds, DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences, ServiceErrorHandling errorHandling) throws Exception {
        DeleteItemRequest request = new DeleteItemRequest(this, errorHandling);
        request.getItemIds().addRange(itemIds);
        request.setDeleteMode(deleteMode);
        request.setSendCancellationsMode(sendCancellationsMode);
        request.setAffectedTaskOccurrences(affectedTaskOccurrences);
        return request.execute();
    }

    public ServiceResponseCollection<ServiceResponse> deleteItems(Iterable<ItemId> itemIds, DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) throws Exception {
        EwsUtilities.validateParamCollection(itemIds.iterator(), "itemIds");
        return this.internalDeleteItems(itemIds, deleteMode, sendCancellationsMode, affectedTaskOccurrences, ServiceErrorHandling.ReturnErrors);
    }

    protected void deleteItem(ItemId itemId, DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) throws Exception {
        ArrayList<ItemId> itemIdArray = new ArrayList<ItemId>();
        itemIdArray.add(itemId);
        EwsUtilities.validateParam(itemId, "itemId");
        this.internalDeleteItems(itemIdArray, deleteMode, sendCancellationsMode, affectedTaskOccurrences, ServiceErrorHandling.ThrowOnError);
    }

    private ServiceResponseCollection<GetAttachmentResponse> internalGetAttachments(Iterable<Attachment> attachments, BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties, ServiceErrorHandling errorHandling) throws Exception {
        GetAttachmentRequest request = new GetAttachmentRequest(this, errorHandling);
        Iterator<Attachment> it = attachments.iterator();
        while (it.hasNext()) {
            ((ArrayList)request.getAttachments()).add(it.next());
        }
        request.setBodyType(bodyType);
        ArrayList<Iterable<PropertyDefinitionBase>> propsArray = new ArrayList<Iterable<PropertyDefinitionBase>>();
        propsArray.add(additionalProperties);
        if (additionalProperties != null) {
            request.getAdditionalProperties().addAll(propsArray);
        }
        return request.execute();
    }

    protected ServiceResponseCollection<GetAttachmentResponse> getAttachments(Attachment[] attachments, BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        ArrayList<Attachment> attList = new ArrayList<Attachment>();
        for (Attachment attachment : attachments) {
            attList.add(attachment);
        }
        return this.internalGetAttachments(attList, bodyType, additionalProperties, ServiceErrorHandling.ReturnErrors);
    }

    protected void getAttachment(Attachment attachment, BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        ArrayList<Attachment> attachmentArray = new ArrayList<Attachment>();
        attachmentArray.add(attachment);
        this.internalGetAttachments(attachmentArray, bodyType, additionalProperties, ServiceErrorHandling.ThrowOnError);
    }

    protected ServiceResponseCollection<CreateAttachmentResponse> createAttachments(String parentItemId, Iterable<Attachment> attachments) throws ServiceResponseException, Exception {
        CreateAttachmentRequest request = new CreateAttachmentRequest(this, ServiceErrorHandling.ReturnErrors);
        request.setParentItemId(parentItemId);
        request.getAttachments().addAll((Collection)attachments);
        return request.execute();
    }

    protected ServiceResponseCollection<DeleteAttachmentResponse> deleteAttachments(Iterable<Attachment> attachments) throws ServiceResponseException, Exception {
        DeleteAttachmentRequest request = new DeleteAttachmentRequest(this, ServiceErrorHandling.ReturnErrors);
        request.getAttachments().addAll((Collection)attachments);
        return request.execute();
    }

    public NameResolutionCollection resolveName(String nameToResolve) throws Exception {
        return this.resolveName(nameToResolve, ResolveNameSearchLocation.ContactsThenDirectory, false);
    }

    public NameResolutionCollection resolveName(String nameToResolve, Iterable<FolderId> parentFolderIds, ResolveNameSearchLocation searchScope, boolean returnContactDetails) throws Exception {
        EwsUtilities.validateParam(nameToResolve, "nameToResolve");
        if (parentFolderIds != null) {
            EwsUtilities.validateParamCollection(parentFolderIds.iterator(), "parentFolderIds");
        }
        ResolveNamesRequest request = new ResolveNamesRequest(this);
        request.setNameToResolve(nameToResolve);
        request.setReturnFullContactData(returnContactDetails);
        request.getParentFolderIds().addRangeFolderId(parentFolderIds);
        request.setSearchLocation(searchScope);
        return ((ResolveNamesResponse)request.execute().getResponseAtIndex(0)).getResolutions();
    }

    public NameResolutionCollection resolveName(String nameToResolve, ResolveNameSearchLocation searchScope, boolean returnContactDetails) throws Exception {
        return this.resolveName(nameToResolve, null, searchScope, returnContactDetails);
    }

    public ExpandGroupResults expandGroup(EmailAddress emailAddress) throws IndexOutOfBoundsException, Exception {
        EwsUtilities.validateParam(emailAddress, "emailAddress");
        ExpandGroupRequest request = new ExpandGroupRequest(this);
        request.setEmailAddress(emailAddress);
        return ((ExpandGroupResponse)request.execute().getResponseAtIndex(0)).getMembers();
    }

    public ExpandGroupResults expandGroup(ItemId groupId) throws Exception {
        EwsUtilities.validateParam(groupId, "groupId");
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setId(groupId);
        return this.expandGroup(emailAddress);
    }

    public ExpandGroupResults expandGroup(String smtpAddress) throws Exception {
        EwsUtilities.validateParam(smtpAddress, "smtpAddress");
        return this.expandGroup(new EmailAddress(smtpAddress));
    }

    public ExpandGroupResults expandGroup(String address, String routingType) throws Exception {
        EwsUtilities.validateParam(address, "address");
        EwsUtilities.validateParam(routingType, "routingType");
        EmailAddress emailAddress = new EmailAddress(address);
        emailAddress.setRoutingType(routingType);
        return this.expandGroup(emailAddress);
    }

    public PullSubscription subscribeToPullNotificationsOnAllFolders(int timeout, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010, "SubscribeToPullNotificationsOnAllFolders");
        return this.internalSubscribeToPullNotifications(null, timeout, watermark, eventTypes);
    }

    public PullSubscription subscribeToPullNotifications(Iterable<FolderId> folderIds, int timeout, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateParamCollection(folderIds.iterator(), "folderIds");
        return this.internalSubscribeToPullNotifications(folderIds, timeout, watermark, eventTypes);
    }

    private PullSubscription internalSubscribeToPullNotifications(Iterable<FolderId> folderIds, int timeout, String watermark, EventType[] eventTypes) throws Exception {
        if (timeout < 1 || timeout > 1440) {
            throw new IllegalArgumentException("timeout", new Throwable(Strings.TimeoutMustBeBetween1And1440));
        }
        EwsUtilities.validateParamCollection(eventTypes, "eventTypes");
        SubscribeToPullNotificationsRequest request = new SubscribeToPullNotificationsRequest(this);
        if (folderIds != null) {
            request.getFolderIds().addRangeFolderId(folderIds);
        }
        request.setTimeOut(timeout);
        for (EventType event : eventTypes) {
            request.getEventTypes().add(event);
        }
        request.setWatermark(watermark);
        return (PullSubscription)((SubscribeResponse)request.execute().getResponseAtIndex(0)).getSubscription();
    }

    protected void unsubscribe(String subscriptionId) throws Exception {
        EwsUtilities.validateParam(subscriptionId, "subscriptionId");
        UnsubscribeRequest request = new UnsubscribeRequest(this);
        request.setSubscriptionId(subscriptionId);
        request.execute();
    }

    protected GetEventsResults getEvents(String subscriptionId, String waterMark) throws Exception {
        EwsUtilities.validateParam(subscriptionId, "subscriptionId");
        EwsUtilities.validateParam(waterMark, "watermark");
        GetEventsRequest request = new GetEventsRequest(this);
        request.setSubscriptionId(subscriptionId);
        request.setWatermark(waterMark);
        return ((GetEventsResponse)request.execute().getResponseAtIndex(0)).getResults();
    }

    public PushSubscription subscribeToPushNotifications(Iterable<FolderId> folderIds, URI url, int frequency, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateParamCollection(folderIds.iterator(), "folderIds");
        return this.internalSubscribeToPushNotifications(folderIds, url, frequency, watermark, eventTypes);
    }

    public PushSubscription subscribeToPushNotificationsOnAllFolders(URI url, int frequency, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010, "SubscribeToPushNotificationsOnAllFolders");
        return this.internalSubscribeToPushNotifications(null, url, frequency, watermark, eventTypes);
    }

    private PushSubscription internalSubscribeToPushNotifications(Iterable<FolderId> folderIds, URI url, int frequency, String watermark, EventType[] eventTypes) throws Exception {
        EwsUtilities.validateParam(url, "url");
        if (frequency < 1 || frequency > 1440) {
            throw new ArgumentOutOfRangeException("frequency", Strings.FrequencyMustBeBetween1And1440);
        }
        EwsUtilities.validateParamCollection(eventTypes, "eventTypes");
        SubscribeToPushNotificationsRequest request = new SubscribeToPushNotificationsRequest(this);
        if (folderIds != null) {
            request.getFolderIds().addRangeFolderId(folderIds);
        }
        request.setUrl(url);
        request.setFrequency(frequency);
        for (EventType event : eventTypes) {
            request.getEventTypes().add(event);
        }
        request.setWatermark(watermark);
        return (PushSubscription)((SubscribeResponse)request.execute().getResponseAtIndex(0)).getSubscription();
    }

    public StreamingSubscription subscribeToStreamingNotificationsOnAllFolders(EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "SubscribeToStreamingNotificationsOnAllFolders");
        return this.internalSubscribeToStreamingNotifications(null, eventTypes);
    }

    public StreamingSubscription subscribeToStreamingNotifications(Iterable<FolderId> folderIds, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "SubscribeToStreamingNotifications");
        return this.internalSubscribeToStreamingNotifications(folderIds, eventTypes);
    }

    private StreamingSubscription internalSubscribeToStreamingNotifications(Iterable<FolderId> folderIds, EventType[] eventTypes) throws Exception {
        EwsUtilities.validateParamCollection(eventTypes, "eventTypes");
        SubscribeToStreamingNotificationsRequest request = new SubscribeToStreamingNotificationsRequest(this);
        if (folderIds != null) {
            request.getFolderIds().addRangeFolderId(folderIds);
        }
        for (EventType event : eventTypes) {
            request.getEventTypes().add(event);
        }
        return (StreamingSubscription)((SubscribeResponse)request.execute().getResponseAtIndex(0)).getSubscription();
    }

    public ChangeCollection<ItemChange> syncFolderItems(FolderId syncFolderId, PropertySet propertySet, Iterable<ItemId> ignoredItemIds, int maxChangesReturned, SyncFolderItemsScope syncScope, String syncState) throws Exception {
        EwsUtilities.validateParam(syncFolderId, "syncFolderId");
        EwsUtilities.validateParam(propertySet, "propertySet");
        SyncFolderItemsRequest request = new SyncFolderItemsRequest(this);
        request.setSyncFolderId(syncFolderId);
        request.setPropertySet(propertySet);
        if (ignoredItemIds != null) {
            request.getIgnoredItemIds().addRange(ignoredItemIds);
        }
        request.setMaxChangesReturned(maxChangesReturned);
        request.setSyncScope(syncScope);
        request.setSyncState(syncState);
        return ((SyncFolderItemsResponse)request.execute().getResponseAtIndex(0)).getChanges();
    }

    public ChangeCollection<FolderChange> syncFolderHierarchy(FolderId syncFolderId, PropertySet propertySet, String syncState) throws Exception {
        EwsUtilities.validateParamAllowNull(syncFolderId, "syncFolderId");
        EwsUtilities.validateParam(propertySet, "propertySet");
        SyncFolderHierarchyRequest request = new SyncFolderHierarchyRequest(this);
        request.setPropertySet(propertySet);
        request.setSyncFolderId(syncFolderId);
        request.setSyncState(syncState);
        return ((SyncFolderHierarchyResponse)request.execute().getResponseAtIndex(0)).getChanges();
    }

    public ChangeCollection<FolderChange> syncFolderHierarchy(PropertySet propertySet, String syncState) throws Exception {
        EwsUtilities.validateParam(propertySet, "propertySet");
        return this.syncFolderHierarchy(null, propertySet, syncState);
    }

    public OofSettings getUserOofSettings(String smtpAddress) throws Exception {
        EwsUtilities.validateParam(smtpAddress, "smtpAddress");
        GetUserOofSettingsRequest request = new GetUserOofSettingsRequest(this);
        request.setSmtpAddress(smtpAddress);
        return request.execute().getOofSettings();
    }

    public void setUserOofSettings(String smtpAddress, OofSettings oofSettings) throws Exception {
        EwsUtilities.validateParam(smtpAddress, "smtpAddress");
        EwsUtilities.validateParam(oofSettings, "oofSettings");
        SetUserOofSettingsRequest request = new SetUserOofSettingsRequest(this);
        request.setSmtpAddress(smtpAddress);
        request.setOofSettings(oofSettings);
        request.execute();
    }

    public GetUserAvailabilityResults getUserAvailability(Iterable<AttendeeInfo> attendees, TimeWindow timeWindow, AvailabilityData requestedData, AvailabilityOptions options) throws Exception {
        EwsUtilities.validateParamCollection(attendees.iterator(), "attendees");
        EwsUtilities.validateParam(timeWindow, "timeWindow");
        EwsUtilities.validateParam(options, "options");
        GetUserAvailabilityRequest request = new GetUserAvailabilityRequest(this);
        request.setAttendees(attendees);
        request.setTimeWindow(timeWindow);
        request.setRequestedData(requestedData);
        request.setOptions(options);
        return request.execute();
    }

    public GetUserAvailabilityResults getUserAvailability(Iterable<AttendeeInfo> attendees, TimeWindow timeWindow, AvailabilityData requestedData) throws Exception {
        return this.getUserAvailability(attendees, timeWindow, requestedData, new AvailabilityOptions());
    }

    public EmailAddressCollection getRoomLists() throws Exception {
        GetRoomListsRequest request = new GetRoomListsRequest(this);
        return request.execute().getRoomLists();
    }

    public Collection<EmailAddress> getRooms(EmailAddress emailAddress) throws Exception {
        EwsUtilities.validateParam(emailAddress, "emailAddress");
        GetRoomsRequest request = new GetRoomsRequest(this);
        request.setRoomList(emailAddress);
        return request.execute().getRooms();
    }

    private Collection<Conversation> findConversation(ConversationIndexedItemView view, SearchFilter.IsEqualTo filter, FolderId folderId) throws Exception {
        EwsUtilities.validateParam(view, "view");
        EwsUtilities.validateParamAllowNull(filter, "filter");
        EwsUtilities.validateParam(folderId, "folderId");
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "FindConversation");
        FindConversationRequest request = new FindConversationRequest(this);
        request.setIndexedItemView(view);
        request.setConversationViewFilter(filter);
        request.setFolderId(new FolderIdWrapper(folderId));
        return request.execute().getConversations();
    }

    public Collection<Conversation> findConversation(ConversationIndexedItemView view, FolderId folderId) throws Exception {
        return this.findConversation(view, null, folderId);
    }

    private ServiceResponseCollection<ServiceResponse> applyConversationAction(ConversationActionType actionType, Iterable<ConversationId> conversationIds, boolean processRightAway, StringList categories, boolean enableAlwaysDelete, FolderId destinationFolderId, ServiceErrorHandling errorHandlingMode) throws Exception {
        EwsUtilities.EwsAssert(actionType == ConversationActionType.AlwaysCategorize || actionType == ConversationActionType.AlwaysMove || actionType == ConversationActionType.AlwaysDelete, "ApplyConversationAction", "Invalic actionType");
        EwsUtilities.validateParam(conversationIds, "conversationId");
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "ApplyConversationAction");
        ApplyConversationActionRequest request = new ApplyConversationActionRequest(this, errorHandlingMode);
        ConversationAction action = new ConversationAction();
        for (ConversationId conversationId : conversationIds) {
            action.setAction(actionType);
            action.setConversationId(conversationId);
            action.setProcessRightAway(processRightAway);
            action.setCategories(categories);
            action.setEnableAlwaysDelete(enableAlwaysDelete);
            action.setDestinationFolderId(destinationFolderId != null ? new FolderIdWrapper(destinationFolderId) : null);
            request.getConversationActions().add(action);
        }
        return request.execute();
    }

    private ServiceResponseCollection<ServiceResponse> applyConversationOneTimeAction(ConversationActionType actionType, Iterable<HashMap<ConversationId, Date>> idTimePairs, FolderId contextFolderId, FolderId destinationFolderId, DeleteMode deleteType, Boolean isRead, ServiceErrorHandling errorHandlingMode) throws Exception {
        EwsUtilities.EwsAssert(actionType == ConversationActionType.Move || actionType == ConversationActionType.Delete || actionType == ConversationActionType.SetReadState || actionType == ConversationActionType.Copy, "ApplyConversationOneTimeAction", "Invalid actionType");
        EwsUtilities.validateParamCollection(idTimePairs.iterator(), "idTimePairs");
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "ApplyConversationAction");
        ApplyConversationActionRequest request = new ApplyConversationActionRequest(this, errorHandlingMode);
        for (HashMap<ConversationId, Date> idTimePair : idTimePairs) {
            ConversationAction action = new ConversationAction();
            action.setAction(actionType);
            action.setConversationId(idTimePair.keySet().iterator().next());
            action.setContextFolderId(contextFolderId != null ? new FolderIdWrapper(contextFolderId) : null);
            action.setDestinationFolderId(destinationFolderId != null ? new FolderIdWrapper(destinationFolderId) : null);
            action.setConversationLastSyncTime(idTimePair.values().iterator().next());
            action.setIsRead(isRead);
            action.setDeleteType(deleteType);
            request.getConversationActions().add(action);
        }
        return request.execute();
    }

    public ServiceResponseCollection<ServiceResponse> enableAlwaysCategorizeItemsInConversations(Iterable<ConversationId> conversationId, Iterable<String> categories, boolean processSynchronously) throws Exception {
        EwsUtilities.validateParamCollection(categories.iterator(), "categories");
        return this.applyConversationAction(ConversationActionType.AlwaysCategorize, conversationId, processSynchronously, new StringList(categories), false, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> disableAlwaysCategorizeItemsInConversations(Iterable<ConversationId> conversationId, boolean processSynchronously) throws Exception {
        return this.applyConversationAction(ConversationActionType.AlwaysCategorize, conversationId, processSynchronously, null, false, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> enableAlwaysDeleteItemsInConversations(Iterable<ConversationId> conversationId, boolean processSynchronously) throws Exception {
        return this.applyConversationAction(ConversationActionType.AlwaysDelete, conversationId, processSynchronously, null, true, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> disableAlwaysDeleteItemsInConversations(Iterable<ConversationId> conversationId, boolean processSynchronously) throws Exception {
        return this.applyConversationAction(ConversationActionType.AlwaysDelete, conversationId, processSynchronously, null, false, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> enableAlwaysMoveItemsInConversations(Iterable<ConversationId> conversationId, FolderId destinationFolderId, boolean processSynchronously) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.applyConversationAction(ConversationActionType.AlwaysMove, conversationId, processSynchronously, null, false, destinationFolderId, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> disableAlwaysMoveItemsInConversations(Iterable<ConversationId> conversationIds, boolean processSynchronously) throws Exception {
        return this.applyConversationAction(ConversationActionType.AlwaysMove, conversationIds, processSynchronously, null, false, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> moveItemsInConversations(Iterable<HashMap<ConversationId, Date>> idLastSyncTimePairs, FolderId contextFolderId, FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.applyConversationOneTimeAction(ConversationActionType.Move, idLastSyncTimePairs, contextFolderId, destinationFolderId, null, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> copyItemsInConversations(Iterable<HashMap<ConversationId, Date>> idLastSyncTimePairs, FolderId contextFolderId, FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.applyConversationOneTimeAction(ConversationActionType.Copy, idLastSyncTimePairs, contextFolderId, destinationFolderId, null, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> deleteItemsInConversations(Iterable<HashMap<ConversationId, Date>> idLastSyncTimePairs, FolderId contextFolderId, DeleteMode deleteMode) throws Exception {
        return this.applyConversationOneTimeAction(ConversationActionType.Delete, idLastSyncTimePairs, contextFolderId, null, deleteMode, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> setReadStateForItemsInConversations(Iterable<HashMap<ConversationId, Date>> idLastSyncTimePairs, FolderId contextFolderId, boolean isRead) throws Exception {
        return this.applyConversationOneTimeAction(ConversationActionType.SetReadState, idLastSyncTimePairs, contextFolderId, null, null, isRead, ServiceErrorHandling.ReturnErrors);
    }

    private ServiceResponseCollection<ConvertIdResponse> internalConvertIds(Iterable<AlternateIdBase> ids, IdFormat destinationFormat, ServiceErrorHandling errorHandling) throws Exception {
        EwsUtilities.validateParamCollection(ids.iterator(), "ids");
        ConvertIdRequest request = new ConvertIdRequest(this, errorHandling);
        request.getIds().addAll((Collection)ids);
        request.setDestinationFormat(destinationFormat);
        return request.execute();
    }

    public ServiceResponseCollection<ConvertIdResponse> convertIds(Iterable<AlternateIdBase> ids, IdFormat destinationFormat) throws Exception {
        EwsUtilities.validateParamCollection(ids.iterator(), "ids");
        return this.internalConvertIds(ids, destinationFormat, ServiceErrorHandling.ReturnErrors);
    }

    public AlternateIdBase convertId(AlternateIdBase id, IdFormat destinationFormat) throws Exception {
        EwsUtilities.validateParam(id, "id");
        ArrayList<AlternateIdBase> alternateIdBaseArray = new ArrayList<AlternateIdBase>();
        alternateIdBaseArray.add(id);
        ServiceResponseCollection<ConvertIdResponse> responses = this.internalConvertIds(alternateIdBaseArray, destinationFormat, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getConvertedId();
    }

    public Collection<DelegateUserResponse> addDelegates(Mailbox mailbox, MeetingRequestsDeliveryScope meetingRequestsDeliveryScope, DelegateUser ... delegateUsers) throws Exception {
        ArrayList<DelegateUser> delUser = new ArrayList<DelegateUser>();
        for (DelegateUser user : delegateUsers) {
            delUser.add(user);
        }
        return this.addDelegates(mailbox, meetingRequestsDeliveryScope, delUser);
    }

    public Collection<DelegateUserResponse> addDelegates(Mailbox mailbox, MeetingRequestsDeliveryScope meetingRequestsDeliveryScope, Iterable<DelegateUser> delegateUsers) throws Exception {
        EwsUtilities.validateParam(mailbox, "mailbox");
        EwsUtilities.validateParamCollection(delegateUsers.iterator(), "delegateUsers");
        AddDelegateRequest request = new AddDelegateRequest(this);
        request.setMailbox(mailbox);
        for (DelegateUser user : delegateUsers) {
            request.getDelegateUsers().add(user);
        }
        request.setMeetingRequestsDeliveryScope(meetingRequestsDeliveryScope);
        Object response = request.execute();
        return ((DelegateManagementResponse)response).getDelegateUserResponses();
    }

    public Collection<DelegateUserResponse> updateDelegates(Mailbox mailbox, MeetingRequestsDeliveryScope meetingRequestsDeliveryScope, DelegateUser ... delegateUsers) throws Exception {
        ArrayList<DelegateUser> delUser = new ArrayList<DelegateUser>();
        for (DelegateUser user : delegateUsers) {
            delUser.add(user);
        }
        return this.updateDelegates(mailbox, meetingRequestsDeliveryScope, delUser);
    }

    public Collection<DelegateUserResponse> updateDelegates(Mailbox mailbox, MeetingRequestsDeliveryScope meetingRequestsDeliveryScope, Iterable<DelegateUser> delegateUsers) throws Exception {
        EwsUtilities.validateParam(mailbox, "mailbox");
        EwsUtilities.validateParamCollection(delegateUsers.iterator(), "delegateUsers");
        UpdateDelegateRequest request = new UpdateDelegateRequest(this);
        request.setMailbox(mailbox);
        ArrayList<DelegateUser> delUser = new ArrayList<DelegateUser>();
        for (DelegateUser user : delegateUsers) {
            delUser.add(user);
        }
        request.getDelegateUsers().addAll(delUser);
        request.setMeetingRequestsDeliveryScope(meetingRequestsDeliveryScope);
        Object response = request.execute();
        return ((DelegateManagementResponse)response).getDelegateUserResponses();
    }

    public Collection<DelegateUserResponse> removeDelegates(Mailbox mailbox, UserId ... userIds) throws Exception {
        ArrayList<UserId> delUser = new ArrayList<UserId>();
        for (UserId user : userIds) {
            delUser.add(user);
        }
        return this.removeDelegates(mailbox, delUser);
    }

    public Collection<DelegateUserResponse> removeDelegates(Mailbox mailbox, Iterable<UserId> userIds) throws Exception {
        EwsUtilities.validateParam(mailbox, "mailbox");
        EwsUtilities.validateParamCollection(userIds.iterator(), "userIds");
        RemoveDelegateRequest request = new RemoveDelegateRequest(this);
        request.setMailbox(mailbox);
        ArrayList<UserId> delUser = new ArrayList<UserId>();
        for (UserId user : userIds) {
            delUser.add(user);
        }
        request.getUserIds().addAll(delUser);
        Object response = request.execute();
        return ((DelegateManagementResponse)response).getDelegateUserResponses();
    }

    public DelegateInformation getDelegates(Mailbox mailbox, boolean includePermissions, UserId ... userIds) throws Exception {
        ArrayList<UserId> delUser = new ArrayList<UserId>();
        for (UserId user : userIds) {
            delUser.add(user);
        }
        return this.getDelegates(mailbox, includePermissions, delUser);
    }

    public DelegateInformation getDelegates(Mailbox mailbox, boolean includePermissions, Iterable<UserId> userIds) throws Exception {
        EwsUtilities.validateParam(mailbox, "mailbox");
        GetDelegateRequest request = new GetDelegateRequest(this);
        request.setMailbox(mailbox);
        ArrayList<UserId> delUser = new ArrayList<UserId>();
        for (UserId user : userIds) {
            delUser.add(user);
        }
        request.getUserIds().addAll(delUser);
        request.setIncludePermissions(includePermissions);
        GetDelegateResponse response = (GetDelegateResponse)request.execute();
        DelegateInformation delegateInformation = new DelegateInformation((List)response.getDelegateUserResponses(), response.getMeetingRequestsDeliveryScope());
        return delegateInformation;
    }

    protected void createUserConfiguration(UserConfiguration userConfiguration) throws Exception {
        EwsUtilities.validateParam(userConfiguration, "userConfiguration");
        CreateUserConfigurationRequest request = new CreateUserConfigurationRequest(this);
        request.setUserConfiguration(userConfiguration);
        request.execute();
    }

    protected void deleteUserConfiguration(String name, FolderId parentFolderId) throws Exception {
        EwsUtilities.validateParam(name, "name");
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        DeleteUserConfigurationRequest request = new DeleteUserConfigurationRequest(this);
        request.setName(name);
        request.setParentFolderId(parentFolderId);
        request.execute();
    }

    protected UserConfiguration getUserConfiguration(String name, FolderId parentFolderId, UserConfigurationProperties properties) throws IndexOutOfBoundsException, Exception {
        EwsUtilities.validateParam(name, "name");
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        GetUserConfigurationRequest request = new GetUserConfigurationRequest(this);
        request.setName(name);
        request.setParentFolderId(parentFolderId);
        request.setProperties(EnumSet.of(properties));
        return ((GetUserConfigurationResponse)request.execute().getResponseAtIndex(0)).getUserConfiguration();
    }

    protected void loadPropertiesForUserConfiguration(UserConfiguration userConfiguration, UserConfigurationProperties properties) throws Exception {
        EwsUtilities.EwsAssert(userConfiguration != null, "ExchangeService.LoadPropertiesForUserConfiguration", "userConfiguration is null");
        GetUserConfigurationRequest request = new GetUserConfigurationRequest(this);
        request.setUserConfiguration(userConfiguration);
        request.setProperties(EnumSet.of(properties));
        request.execute();
    }

    protected void updateUserConfiguration(UserConfiguration userConfiguration) throws Exception {
        EwsUtilities.validateParam(userConfiguration, "userConfiguration");
        UpdateUserConfigurationRequest request = new UpdateUserConfigurationRequest(this);
        request.setUserConfiguration(userConfiguration);
        request.execute();
    }

    public RuleCollection getInboxRules() throws Exception {
        GetInboxRulesRequest request = new GetInboxRulesRequest(this);
        return request.execute().getRules();
    }

    public RuleCollection getInboxRules(String mailboxSmtpAddress) throws Exception {
        EwsUtilities.validateParam(mailboxSmtpAddress, "MailboxSmtpAddress");
        GetInboxRulesRequest request = new GetInboxRulesRequest(this);
        request.setmailboxSmtpAddress(mailboxSmtpAddress);
        return request.execute().getRules();
    }

    public void updateInboxRules(Iterable<RuleOperation> operations, boolean removeOutlookRuleBlob) throws Exception {
        UpdateInboxRulesRequest request = new UpdateInboxRulesRequest(this);
        request.setInboxRuleOperations(operations);
        request.setRemoveOutlookRuleBlob(removeOutlookRuleBlob);
        request.execute();
    }

    public void updateInboxRules(Iterable<RuleOperation> operations, boolean removeOutlookRuleBlob, String mailboxSmtpAddress) throws Exception {
        UpdateInboxRulesRequest request = new UpdateInboxRulesRequest(this);
        request.setInboxRuleOperations(operations);
        request.setRemoveOutlookRuleBlob(removeOutlookRuleBlob);
        request.setMailboxSmtpAddress(mailboxSmtpAddress);
        request.execute();
    }

    private boolean defaultAutodiscoverRedirectionUrlValidationCallback(String redirectionUrl) throws AutodiscoverLocalException {
        throw new AutodiscoverLocalException(String.format(Strings.AutodiscoverRedirectBlocked, redirectionUrl));
    }

    public void autodiscoverUrl(String emailAddress) throws Exception {
        this.autodiscoverUrl(emailAddress, this);
    }

    public void autodiscoverUrl(String emailAddress, IAutodiscoverRedirectionUrl validateRedirectionUrlCallback) throws Exception {
        URI exchangeServiceUrl = null;
        if (this.getRequestedServerVersion().ordinal() > ExchangeVersion.Exchange2007_SP1.ordinal()) {
            try {
                exchangeServiceUrl = this.getAutodiscoverUrl(emailAddress, this.getRequestedServerVersion(), validateRedirectionUrlCallback);
                this.setUrl(this.adjustServiceUriFromCredentials(exchangeServiceUrl));
                return;
            }
            catch (AutodiscoverLocalException ex) {
                this.traceMessage(TraceFlags.AutodiscoverResponse, String.format("Autodiscover service call failed with error '%s'. Will try legacy service", ex.getMessage()));
            }
            catch (ServiceRemoteException ex) {
                if (ex instanceof AccountIsLockedException) {
                    throw new AccountIsLockedException(ex.getMessage(), exchangeServiceUrl, ex);
                }
                this.traceMessage(TraceFlags.AutodiscoverResponse, String.format("Autodiscover service call failed with error '%s'. Will try legacy service", ex.getMessage()));
            }
        }
        exchangeServiceUrl = this.getAutodiscoverUrl(emailAddress, ExchangeVersion.Exchange2007_SP1, validateRedirectionUrlCallback);
        this.setUrl(this.adjustServiceUriFromCredentials(exchangeServiceUrl));
    }

    private URI adjustServiceUriFromCredentials(URI uri) throws URISyntaxException {
        return this.getCredentials() != null ? this.getCredentials().adjustUrl(uri) : uri;
    }

    private URI getAutodiscoverUrl(String emailAddress, ExchangeVersion requestedServerVersion, IAutodiscoverRedirectionUrl validateRedirectionUrlCallback) throws Exception {
        AutodiscoverService autodiscoverService = new AutodiscoverService(this, requestedServerVersion);
        autodiscoverService.setRedirectionUrlValidationCallback(validateRedirectionUrlCallback);
        autodiscoverService.setEnableScpLookup(this.getEnableScpLookup());
        GetUserSettingsResponse response = autodiscoverService.getUserSettings(emailAddress, UserSettingName.InternalEwsUrl, UserSettingName.ExternalEwsUrl);
        switch (response.getErrorCode()) {
            case NoError: {
                autodiscoverService.isExternal();
                return this.getEwsUrlFromResponse(response, Boolean.TRUE);
            }
            case InvalidUser: {
                throw new ServiceRemoteException(String.format(Strings.InvalidUser, emailAddress));
            }
            case InvalidRequest: {
                throw new ServiceRemoteException(String.format(Strings.InvalidAutodiscoverRequest, response.getErrorMessage()));
            }
        }
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("No EWS Url returned for user %s, error code is %s", new Object[]{emailAddress, response.getErrorCode()}));
        throw new ServiceRemoteException(response.getErrorMessage());
    }

    private URI getEwsUrlFromResponse(GetUserSettingsResponse response, boolean isExternal) throws URISyntaxException, AutodiscoverLocalException {
        String uriString;
        OutParam outParam = new OutParam();
        if (isExternal && response.tryGetSettingValue(String.class, UserSettingName.ExternalEwsUrl, outParam) && (uriString = (String)outParam.getParam()) != null && !uriString.isEmpty()) {
            return new URI(uriString);
        }
        if ((response.tryGetSettingValue(String.class, UserSettingName.InternalEwsUrl, outParam) || response.tryGetSettingValue(String.class, UserSettingName.ExternalEwsUrl, outParam)) && (uriString = (String)outParam.getParam()) != null && !uriString.isEmpty()) {
            return new URI(uriString);
        }
        throw new AutodiscoverLocalException(Strings.AutodiscoverDidNotReturnEwsUrl);
    }

    protected Document executeDiagnosticMethod(String verb, Node parameter) throws Exception {
        ExecuteDiagnosticMethodRequest request = new ExecuteDiagnosticMethodRequest(this);
        request.setVerb(verb);
        request.setParameter(parameter);
        return ((ExecuteDiagnosticMethodResponse)request.execute().getResponseAtIndex(0)).getReturnValue();
    }

    @Override
    protected void validate() throws ServiceLocalException {
        super.validate();
        if (this.getUrl() == null) {
            throw new ServiceLocalException(Strings.ServiceUrlMustBeSet);
        }
    }

    public ExchangeService() {
    }

    public ExchangeService(ExchangeVersion requestedServerVersion) {
        super(requestedServerVersion);
    }

    public ExchangeService(ExchangeVersion requestedServerVersion, TimeZone timeZone) {
        super(requestedServerVersion, timeZone);
    }

    protected HttpWebRequest prepareHttpWebRequest() throws ServiceLocalException, URISyntaxException {
        return this.prepareHttpWebRequestForUrl(this.getUrl(), this.getAcceptGzipEncoding(), true);
    }

    @Override
    protected void processHttpErrorResponse(HttpWebRequest httpWebResponse, Exception webException) throws Exception {
        this.internalProcessHttpErrorResponse(httpWebResponse, webException, TraceFlags.EwsResponseHttpHeaders, TraceFlags.EwsResponse);
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public ImpersonatedUserId getImpersonatedUserId() {
        return this.impersonatedUserId;
    }

    public void setImpersonatedUserId(ImpersonatedUserId impersonatedUserId) {
        this.impersonatedUserId = impersonatedUserId;
    }

    public Locale getPreferredCulture() {
        return this.preferredCulture;
    }

    public void setPreferredCulture(Locale preferredCulture) {
        this.preferredCulture = preferredCulture;
    }

    public IFileAttachmentContentHandler getFileAttachmentContentHandler() {
        return this.fileAttachmentContentHandler;
    }

    public void setFileAttachmentContentHandler(IFileAttachmentContentHandler fileAttachmentContentHandler) {
        this.fileAttachmentContentHandler = fileAttachmentContentHandler;
    }

    public UnifiedMessaging getUnifiedMessaging() {
        if (this.unifiedMessaging == null) {
            this.unifiedMessaging = new UnifiedMessaging(this);
        }
        return this.unifiedMessaging;
    }

    public boolean getEnableScpLookup() {
        return this.enableScpLookup;
    }

    public void setEnableScpLookup(boolean value) {
        this.enableScpLookup = value;
    }

    protected boolean getExchange2007CompatibilityMode() {
        return this.exchange2007CompatibilityMode;
    }

    protected void setExchange2007CompatibilityMode(boolean value) {
        this.exchange2007CompatibilityMode = value;
    }

    public Collection<TimeZoneDefinition> getServerTimeZones(Iterable<String> timeZoneIds) {
        Date today = new Date();
        ArrayList<TimeZoneDefinition> timeZoneList = new ArrayList<TimeZoneDefinition>();
        for (String timeZoneId : timeZoneIds) {
            TimeZoneDefinition timeZoneDefinition = new TimeZoneDefinition();
            timeZoneList.add(timeZoneDefinition);
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            timeZoneDefinition.id = timeZone.getID();
            timeZoneDefinition.name = timeZone.getDisplayName(timeZone.inDaylightTime(today), 1);
        }
        return timeZoneList;
    }

    public Collection<TimeZoneDefinition> getServerTimeZones() {
        Date today = new Date();
        ArrayList<TimeZoneDefinition> timeZoneList = new ArrayList<TimeZoneDefinition>();
        for (String timeZoneId : TimeZone.getAvailableIDs()) {
            TimeZoneDefinition timeZoneDefinition = new TimeZoneDefinition();
            timeZoneList.add(timeZoneDefinition);
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            timeZoneDefinition.id = timeZone.getID();
            timeZoneDefinition.name = timeZone.getDisplayName(timeZone.inDaylightTime(today), 1);
        }
        return timeZoneList;
    }

    @Override
    public boolean autodiscoverRedirectionUrlValidationCallback(String redirectionUrl) throws AutodiscoverLocalException {
        return this.defaultAutodiscoverRedirectionUrlValidationCallback(redirectionUrl);
    }
}

