/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ExecuteDiagnosticMethodResponse;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;
import org.w3c.dom.Node;

final class ExecuteDiagnosticMethodRequest
extends MultiResponseServiceRequest<ExecuteDiagnosticMethodResponse> {
    private Node xmlNode;
    private String verb;

    protected ExecuteDiagnosticMethodRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected String getXmlElementName() {
        return "ExecuteDiagnosticMethod";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeElementValue(XmlNamespace.Messages, "Verb", this.getVerb());
        writer.writeStartElement(XmlNamespace.Messages, "Parameter");
        writer.writeNode(this.getParameter());
        writer.writeEndElement();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ExecuteDiagnosticMethodResponse";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected String getVerb() {
        return this.verb;
    }

    protected void setVerb(String value) {
        this.verb = value;
    }

    protected Node getParameter() {
        return this.xmlNode;
    }

    protected void setParameter(Node value) {
        this.xmlNode = value;
    }

    @Override
    protected ExecuteDiagnosticMethodResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ExecuteDiagnosticMethodResponse(service);
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ExecuteDiagnosticMethodResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }
}

