/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.Attachment;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XMLNodeType;
import microsoft.exchange.webservices.data.XmlNamespace;

final class GetAttachmentResponse
extends ServiceResponse {
    private Attachment attachment;

    protected GetAttachmentResponse(Attachment attachment) {
        EwsUtilities.EwsAssert(attachment != null, "GetAttachmentResponse.ctor", "attachment is null");
        this.attachment = attachment;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        super.readElementsFromXml(reader);
        reader.readStartElement(XmlNamespace.Messages, "Attachments");
        if (!reader.isEmptyElement()) {
            XMLNodeType x = new XMLNodeType(1);
            reader.read(x);
            this.attachment.loadFromXml(reader, reader.getLocalName());
            reader.readEndElement(XmlNamespace.Messages, "Attachments");
        } else {
            reader.read();
        }
    }

    protected Attachment getAttachment() {
        return this.attachment;
    }
}

