/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import microsoft.exchange.webservices.data.EventType;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.FolderEvent;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.ItemEvent;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.NotificationEvent;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class GetEventsResults {
    private String newWatermark;
    private String subscriptionId;
    private String previousWatermark;
    private boolean moreEventsAvailable;
    private Collection<NotificationEvent> events = new ArrayList<NotificationEvent>();
    private static LazyMember<Map<String, EventType>> xmlElementNameToEventTypeMap = new LazyMember<Map<String, EventType>>(new ILazyMember<Map<String, EventType>>(){

        @Override
        public Map<String, EventType> createInstance() {
            HashMap<String, EventType> result = new HashMap<String, EventType>();
            result.put("CopiedEvent", EventType.Copied);
            result.put("CreatedEvent", EventType.Created);
            result.put("DeletedEvent", EventType.Deleted);
            result.put("ModifiedEvent", EventType.Modified);
            result.put("MovedEvent", EventType.Moved);
            result.put("NewMailEvent", EventType.NewMail);
            result.put("StatusEvent", EventType.Status);
            result.put("FreeBusyChangedEvent", EventType.FreeBusyChanged);
            return result;
        }
    });

    protected static Map<String, EventType> getXmlElementNameToEventTypeMap() {
        return xmlElementNameToEventTypeMap.getMember();
    }

    protected GetEventsResults() {
    }

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "Notification");
        this.subscriptionId = reader.readElementValue(XmlNamespace.Types, "SubscriptionId");
        this.previousWatermark = reader.readElementValue(XmlNamespace.Types, "PreviousWatermark");
        this.moreEventsAvailable = reader.readElementValue(Boolean.class, XmlNamespace.Types, "MoreEvents");
        do {
            reader.read();
            if (!reader.isStartElement()) continue;
            String eventElementName = reader.getLocalName();
            if (xmlElementNameToEventTypeMap.getMember().containsKey(eventElementName)) {
                EventType eventType = xmlElementNameToEventTypeMap.getMember().get(eventElementName);
                this.newWatermark = reader.readElementValue(XmlNamespace.Types, "Watermark");
                if (eventType == EventType.Status) {
                    reader.readEndElementIfNecessary(XmlNamespace.Types, eventElementName);
                    continue;
                }
                this.loadNotificationEventFromXml(reader, eventElementName, eventType);
                continue;
            }
            reader.skipCurrentElement();
        } while (!reader.isEndElement(XmlNamespace.Messages, "Notification"));
    }

    private void loadNotificationEventFromXml(EwsServiceXmlReader reader, String eventElementName, EventType eventType) throws Exception {
        Date date = reader.readElementValue(Date.class, XmlNamespace.Types, "TimeStamp");
        reader.read();
        NotificationEvent notificationEvent = reader.getLocalName().equals("FolderId") ? new FolderEvent(eventType, date) : new ItemEvent(eventType, date);
        notificationEvent.loadFromXml(reader, eventElementName);
        this.events.add(notificationEvent);
    }

    protected String getSubscriptionId() {
        return this.subscriptionId;
    }

    protected String getPreviousWatermark() {
        return this.previousWatermark;
    }

    protected String getNewWatermark() {
        return this.newWatermark;
    }

    protected boolean isMoreEventsAvailable() {
        return this.moreEventsAvailable;
    }

    public Iterable<FolderEvent> getFolderEvents() {
        ArrayList<FolderEvent> folderEvents = new ArrayList<FolderEvent>();
        for (NotificationEvent event : this.events) {
            if (!(event instanceof FolderEvent)) continue;
            folderEvents.add((FolderEvent)event);
        }
        return folderEvents;
    }

    public Iterable<ItemEvent> getItemEvents() {
        ArrayList<ItemEvent> itemEvents = new ArrayList<ItemEvent>();
        for (NotificationEvent event : this.events) {
            if (!(event instanceof ItemEvent)) continue;
            itemEvents.add((ItemEvent)event);
        }
        return itemEvents;
    }

    public Collection<NotificationEvent> getAllEvents() {
        return this.events;
    }
}

