/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.AttendeeAvailability;
import microsoft.exchange.webservices.data.AttendeeInfo;
import microsoft.exchange.webservices.data.AvailabilityData;
import microsoft.exchange.webservices.data.AvailabilityOptions;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GetUserAvailabilityResults;
import microsoft.exchange.webservices.data.LegacyAvailabilityTimeZone;
import microsoft.exchange.webservices.data.ServiceError;
import microsoft.exchange.webservices.data.ServiceResponseCollection;
import microsoft.exchange.webservices.data.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.SuggestionsResponse;
import microsoft.exchange.webservices.data.TimeWindow;
import microsoft.exchange.webservices.data.XmlNamespace;

final class GetUserAvailabilityRequest
extends SimpleServiceRequestBase {
    private Iterable<AttendeeInfo> attendees;
    private TimeWindow timeWindow;
    private AvailabilityData requestedData = AvailabilityData.FreeBusyAndSuggestions;
    private AvailabilityOptions options;

    protected GetUserAvailabilityRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected String getXmlElementName() {
        return "GetUserAvailabilityRequest";
    }

    protected boolean isFreeBusyViewRequested() {
        return this.requestedData == AvailabilityData.FreeBusy || this.requestedData == AvailabilityData.FreeBusyAndSuggestions;
    }

    protected boolean isSuggestionsViewRequested() {
        return this.requestedData == AvailabilityData.Suggestions || this.requestedData == AvailabilityData.FreeBusyAndSuggestions;
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        this.options.validate(this.timeWindow.getDuration());
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        LegacyAvailabilityTimeZone legacyTimeZone = new LegacyAvailabilityTimeZone();
        legacyTimeZone.writeToXml(writer, "TimeZone");
        writer.writeStartElement(XmlNamespace.Messages, "MailboxDataArray");
        for (AttendeeInfo attendee : this.attendees) {
            attendee.writeToXml(writer);
        }
        writer.writeEndElement();
        this.options.writeToXml(writer, this);
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetUserAvailabilityResponse";
    }

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        GetUserAvailabilityResults serviceResponse = new GetUserAvailabilityResults();
        if (this.isFreeBusyViewRequested()) {
            serviceResponse.setAttendeesAvailability(new ServiceResponseCollection<AttendeeAvailability>());
            reader.readStartElement(XmlNamespace.Messages, "FreeBusyResponseArray");
            do {
                reader.read();
                if (!reader.isStartElement(XmlNamespace.Messages, "FreeBusyResponse")) continue;
                AttendeeAvailability freeBusyResponse = new AttendeeAvailability();
                freeBusyResponse.loadFromXml(reader, "ResponseMessage");
                if (freeBusyResponse.getErrorCode().equals((Object)ServiceError.NoError)) {
                    freeBusyResponse.loadFreeBusyViewFromXml(reader, this.options.getRequestedFreeBusyView());
                }
                serviceResponse.getAttendeesAvailability().add(freeBusyResponse);
            } while (!reader.isEndElement(XmlNamespace.Messages, "FreeBusyResponseArray"));
        }
        if (this.isSuggestionsViewRequested()) {
            serviceResponse.setSuggestionsResponse(new SuggestionsResponse());
            reader.readStartElement(XmlNamespace.Messages, "SuggestionsResponse");
            serviceResponse.getSuggestionsResponse().loadFromXml(reader, "ResponseMessage");
            if (serviceResponse.getSuggestionsResponse().getErrorCode().equals((Object)ServiceError.NoError)) {
                serviceResponse.getSuggestionsResponse().loadSuggestedDaysFromXml(reader);
            }
            reader.readEndElement(XmlNamespace.Messages, "SuggestionsResponse");
        }
        return serviceResponse;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected GetUserAvailabilityResults execute() throws Exception {
        return (GetUserAvailabilityResults)this.internalExecute();
    }

    public Iterable<AttendeeInfo> getAttendees() {
        return this.attendees;
    }

    public void setAttendees(Iterable<AttendeeInfo> attendees) {
        this.attendees = attendees;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public void setTimeWindow(TimeWindow timeWindow) {
        this.timeWindow = timeWindow;
    }

    public AvailabilityData getRequestedData() {
        return this.requestedData;
    }

    public void setRequestedData(AvailabilityData requestedData) {
        this.requestedData = requestedData;
    }

    public AvailabilityOptions getOptions() {
        return this.options;
    }

    public void setOptions(AvailabilityOptions options) {
        this.options = options;
    }
}

