/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import microsoft.exchange.webservices.data.AlternateMailboxCollection;
import microsoft.exchange.webservices.data.AutodiscoverResponse;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.ProtocolConnectionCollection;
import microsoft.exchange.webservices.data.UserSettingError;
import microsoft.exchange.webservices.data.UserSettingName;
import microsoft.exchange.webservices.data.WebClientUrlCollection;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class GetUserSettingsResponse
extends AutodiscoverResponse {
    private String smtpAddress;
    private String redirectTarget;
    private Map<UserSettingName, Object> settings;
    private Collection<UserSettingError> userSettingErrors;

    public GetUserSettingsResponse() {
        this.setSmtpAddress(null);
        this.setSettings(new HashMap<UserSettingName, Object>());
        this.setUserSettingErrors(new ArrayList<UserSettingError>());
    }

    public <T> boolean tryGetSettingValue(Class<T> cls, UserSettingName setting, OutParam<T> value) {
        if (this.getSettings().containsKey((Object)setting)) {
            Object objValue = this.getSettings().get((Object)setting);
            value.setParam(objValue);
            return true;
        }
        value.setParam((Object)null);
        return false;
    }

    public String getSmtpAddress() {
        return this.smtpAddress;
    }

    protected void setSmtpAddress(String value) {
        this.smtpAddress = value;
    }

    public String getRedirectTarget() {
        return this.redirectTarget;
    }

    protected void setRedirectTarget(String value) {
        this.redirectTarget = value;
    }

    public Map<UserSettingName, Object> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<UserSettingName, Object> settings) {
        this.settings = settings;
    }

    public Collection<UserSettingError> getUserSettingErrors() {
        return this.userSettingErrors;
    }

    protected void setUserSettingErrors(Collection<UserSettingError> value) {
        this.userSettingErrors = value;
    }

    @Override
    protected void loadFromXml(EwsXmlReader reader, String endElementName) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("RedirectTarget")) {
                this.setRedirectTarget(reader.readElementValue());
                continue;
            }
            if (reader.getLocalName().equals("UserSettingErrors")) {
                this.loadUserSettingErrorsFromXml(reader);
                continue;
            }
            if (reader.getLocalName().equals("UserSettings")) {
                this.loadUserSettingsFromXml(reader);
                continue;
            }
            super.loadFromXml(reader, endElementName);
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, endElementName));
    }

    protected void loadUserSettingsFromXml(EwsXmlReader reader) throws Exception {
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1 || !reader.getLocalName().equals("UserSetting")) continue;
                String settingClass = reader.readAttributeValue(XmlNamespace.XmlSchemaInstance, "type");
                if (settingClass.equals("StringSetting")) {
                    this.readSettingFromXml(reader);
                    continue;
                }
                if (settingClass.equals("WebClientUrlCollectionSetting")) {
                    this.readSettingFromXml(reader);
                    continue;
                }
                if (settingClass.equals("AlternateMailboxCollectionSetting")) {
                    this.readSettingFromXml(reader);
                    continue;
                }
                if (settingClass.equals("ProtocolConnectionCollectionSetting")) {
                    this.readSettingFromXml(reader);
                    continue;
                }
                EwsUtilities.EwsAssert(false, "GetUserSettingsResponse.LoadUserSettingsFromXml", String.format("%s,%s", "Invalid setting class '%s' returned", settingClass));
                break;
            } while (!reader.isEndElement(XmlNamespace.Autodiscover, "UserSettings"));
        } else {
            reader.read();
        }
    }

    private void readSettingFromXml(EwsXmlReader reader) throws Exception {
        UserSettingName name = null;
        Object value = null;
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("Name")) {
                name = reader.readElementValue(UserSettingName.class);
                continue;
            }
            if (reader.getLocalName().equals("Value")) {
                value = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("WebClientUrls")) {
                value = WebClientUrlCollection.loadFromXml(reader);
                continue;
            }
            if (reader.getLocalName().equals("ProtocolConnections")) {
                value = ProtocolConnectionCollection.LoadFromXml(reader);
                continue;
            }
            if (!reader.getLocalName().equals("AlternateMailboxes")) continue;
            value = AlternateMailboxCollection.loadFromXml(reader);
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "UserSetting"));
        EwsUtilities.EwsAssert(name != null, "GetUserSettingsResponse.ReadSettingFromXml", "Missing name element in user setting");
        this.getSettings().put(name, value);
    }

    private void loadUserSettingErrorsFromXml(EwsXmlReader reader) throws Exception {
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1 || !reader.getLocalName().equals("UserSettingError")) continue;
                UserSettingError error = new UserSettingError();
                error.loadFromXml(reader);
                this.getUserSettingErrors().add(error);
            } while (!reader.isEndElement(XmlNamespace.Autodiscover, "UserSettingErrors"));
        } else {
            reader.read();
        }
    }
}

