/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.Contact;
import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EmailAddressKey;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.MailboxType;
import microsoft.exchange.webservices.data.MemberStatus;
import microsoft.exchange.webservices.data.RequiredServerVersion;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

@RequiredServerVersion(version=ExchangeVersion.Exchange2010)
public class GroupMember
extends ComplexProperty
implements IComplexPropertyChangedDelegate {
    private EmailAddress addressInformation;
    private MemberStatus status = MemberStatus.Unrecognized;
    private String key = null;

    public GroupMember() {
    }

    public GroupMember(String smtpAddress) {
        this();
        this.setAddressInformation(new EmailAddress(smtpAddress));
    }

    public GroupMember(String address, String routingType, MailboxType mailboxType) throws ServiceLocalException {
        this();
        switch (mailboxType) {
            case PublicGroup: 
            case PublicFolder: 
            case Mailbox: 
            case Contact: 
            case OneOff: {
                this.setAddressInformation(new EmailAddress(null, address, routingType, mailboxType));
                break;
            }
            default: {
                throw new ServiceLocalException(Strings.InvalidMailboxType);
            }
        }
    }

    public GroupMember(String smtpAddress, MailboxType mailboxType) throws ServiceLocalException {
        this(smtpAddress, "SMTP", mailboxType);
    }

    public GroupMember(String name, String address, String routingType) {
        this();
        this.setAddressInformation(new EmailAddress(name, address, routingType, MailboxType.OneOff));
    }

    public GroupMember(String name, String smtpAddress) {
        this(name, smtpAddress, "SMTP");
    }

    public GroupMember(ItemId contactGroupId) {
        this();
        this.setAddressInformation(new EmailAddress(null, null, null, MailboxType.ContactGroup, contactGroupId));
    }

    public GroupMember(ItemId contactId, String addressToLink) {
        this();
        this.setAddressInformation(new EmailAddress(null, addressToLink, null, MailboxType.Contact, contactId));
    }

    public GroupMember(EmailAddress addressInformation) throws Exception {
        this();
        this.setAddressInformation(new EmailAddress(addressInformation));
    }

    protected GroupMember(GroupMember member) throws Exception {
        this();
        EwsUtilities.validateParam(member, "member");
        this.setAddressInformation(new EmailAddress(member.getAddressInformation()));
    }

    public GroupMember(Contact contact, EmailAddressKey emailAddressKey) throws Exception {
        this();
        EwsUtilities.validateParam(contact, "contact");
        EmailAddress emailAddress = contact.getEmailAddresses().getEmailAddress(emailAddressKey);
        this.setAddressInformation(new EmailAddress(emailAddress));
        this.getAddressInformation().setId(contact.getId());
    }

    public String getKey() {
        return this.key;
    }

    public EmailAddress getAddressInformation() {
        return this.addressInformation;
    }

    protected void setAddressInformation(EmailAddress value) {
        if (this.addressInformation != null) {
            this.addressInformation.removeChangeEvent(this);
        }
        this.addressInformation = value;
        if (this.addressInformation != null) {
            this.addressInformation.addOnChangeEvent(this);
        }
    }

    public MemberStatus getStatus() {
        return this.status;
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.key = reader.readAttributeValue(String.class, "Key");
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("Status")) {
            this.status = EwsUtilities.parse(MemberStatus.class, reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equals("Mailbox")) {
            this.setAddressInformation(new EmailAddress());
            this.getAddressInformation().loadFromXml(reader, reader.getLocalName());
            return true;
        }
        return false;
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Key", this.key);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getAddressInformation().writeToXml(writer, XmlNamespace.Types, "Mailbox");
    }

    private void addressInformationChanged(ComplexProperty complexProperty) {
        this.changed();
    }

    @Override
    public void complexPropertyChanged(ComplexProperty complexProperty) {
        this.addressInformationChanged(complexProperty);
    }
}

