/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.EWSHttpException;
import microsoft.exchange.webservices.data.EwsServiceMultiResponseXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.HangingRequestDisconnectEventArgs;
import microsoft.exchange.webservices.data.HangingRequestDisconnectReason;
import microsoft.exchange.webservices.data.HangingTraceStream;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceRequestException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TraceFlags;
import microsoft.exchange.webservices.data.XMLNodeType;
import microsoft.exchange.webservices.data.XmlException;

abstract class HangingServiceRequestBase
extends ServiceRequestBase {
    private static final int BufferSize = 4096;
    protected static boolean LogAllWireBytes = false;
    private IHandleResponseObject responseHandler;
    private HttpWebRequest response;
    private HttpWebRequest request;
    private EwsServiceMultiResponseXmlReader ewsXmlReader;
    protected int heartbeatFrequencyMilliseconds;
    private List<IHangingRequestDisconnectHandler> onDisconnectList = new ArrayList<IHangingRequestDisconnectHandler>();
    private boolean isConnected;

    protected void addOnDisconnectEvent(IHangingRequestDisconnectHandler disconnect) {
        this.onDisconnectList.add(disconnect);
    }

    protected void removeDisconnectEvent(IHangingRequestDisconnectHandler disconnect) {
        this.onDisconnectList.remove(disconnect);
    }

    protected void clearDisconnectEvents() {
        this.onDisconnectList.clear();
    }

    protected HangingServiceRequestBase(ExchangeService service, IHandleResponseObject handler, int heartbeatFrequency) throws ServiceVersionException {
        super(service);
        this.responseHandler = handler;
        this.heartbeatFrequencyMilliseconds = heartbeatFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalExecute() throws ServiceLocalException, Exception {
        HangingServiceRequestBase hangingServiceRequestBase = this;
        synchronized (hangingServiceRequestBase) {
            OutParam<HttpWebRequest> outParam = new OutParam<HttpWebRequest>();
            this.response = this.validateAndEmitRequest(outParam);
            this.request = (HttpWebRequest)outParam.getParam();
            this.internalOnConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResponses(Object state) {
        UUID traceId = UUID.fromString("00000000-0000-0000-0000-000000000000");
        HangingTraceStream tracingStream = null;
        try {
            InputStream responseStream = this.response.getInputStream();
            tracingStream = new HangingTraceStream(responseStream, this.getService());
            while (this.isConnected()) {
                this.ewsXmlReader = EwsServiceMultiResponseXmlReader.create(tracingStream, this.getService());
                Object responseObject = this.readResponse(this.ewsXmlReader);
                this.responseHandler.handleResponseObject(responseObject);
            }
        }
        catch (SocketTimeoutException ex) {
            this.disconnect(HangingRequestDisconnectReason.Timeout, ex);
            return;
        }
        catch (UnknownServiceException ex) {
            this.disconnect(HangingRequestDisconnectReason.Exception, ex);
            return;
        }
        catch (ObjectStreamException ex) {
            this.disconnect(HangingRequestDisconnectReason.Exception, ex);
            return;
        }
        catch (IOException ex) {
            this.disconnect(HangingRequestDisconnectReason.Exception, ex);
            return;
        }
        catch (UnsupportedOperationException ex) {
            ex.printStackTrace();
            this.disconnect(HangingRequestDisconnectReason.UserInitiated, null);
            return;
        }
        catch (Exception ex) {
            this.disconnect(HangingRequestDisconnectReason.Exception, ex);
            return;
        }
        finally {
            ByteArrayOutputStream responseCopy;
            if (tracingStream != null && this.getService().isTraceEnabledFor(TraceFlags.EwsResponse) && (responseCopy = tracingStream.GetResponseCopy()) != null) {
                this.getService().traceXml(TraceFlags.EwsResponse, responseCopy);
            }
        }
    }

    protected boolean isConnected() {
        return this.isConnected;
    }

    private void setIsConnected(boolean value) {
        this.isConnected = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        HangingServiceRequestBase hangingServiceRequestBase = this;
        synchronized (hangingServiceRequestBase) {
            this.request.close();
            this.response.close();
            this.disconnect(HangingRequestDisconnectReason.UserInitiated, null);
        }
    }

    protected void disconnect(HangingRequestDisconnectReason reason, Exception exception) {
        if (this.isConnected()) {
            this.internalOnDisconnect(reason, exception);
        }
    }

    private void internalOnConnect() throws XMLStreamException, IOException, EWSHttpException {
        if (!this.isConnected()) {
            this.isConnected = true;
            if (this.getService().isTraceEnabledFor(TraceFlags.EwsResponseHttpHeaders)) {
                this.getService().traceHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, this.response);
            }
            int poolSize = 1;
            int maxPoolSize = 1;
            long keepAliveTime = 10L;
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(1);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(poolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, queue);
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HangingServiceRequestBase.this.parseResponses(null);
                }
            });
            threadPool.shutdown();
        }
    }

    private void internalOnDisconnect(HangingRequestDisconnectReason reason, Exception exception) {
        if (this.isConnected()) {
            this.isConnected = false;
            for (IHangingRequestDisconnectHandler disconnect : this.onDisconnectList) {
                disconnect.hangingRequestDisconnectHandler(this, new HangingRequestDisconnectEventArgs(reason, exception));
            }
        }
    }

    @Override
    protected void readPreamble(EwsServiceXmlReader ewsXmlReader) throws Exception {
        try {
            ewsXmlReader.read(new XMLNodeType(7));
        }
        catch (XmlException ex) {
            throw new ServiceRequestException(Strings.ServiceResponseDoesNotContainXml, ex);
        }
        catch (ServiceXmlDeserializationException ex) {
            throw new ServiceRequestException(Strings.ServiceResponseDoesNotContainXml, ex);
        }
    }

    protected static interface IHangingRequestDisconnectHandler {
        public void hangingRequestDisconnectHandler(Object var1, HangingRequestDisconnectEventArgs var2);
    }

    protected static interface IHandleResponseObject {
        public void handleResponseObject(Object var1) throws ArgumentException;
    }
}

