/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.TrustManager;
import microsoft.exchange.webservices.data.ByteArrayOSRequestEntity;
import microsoft.exchange.webservices.data.EWSHttpException;
import microsoft.exchange.webservices.data.EwsJCIFSNTLMScheme;
import microsoft.exchange.webservices.data.EwsSSLProtocolSocketFactory;
import microsoft.exchange.webservices.data.HttpProxyCredentials;
import microsoft.exchange.webservices.data.HttpWebRequest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

class HttpClientWebRequest
extends HttpWebRequest {
    private HttpClient client = null;
    private HttpMethodBase httpMethod = null;
    private TrustManager trustManger = null;
    private HttpConnectionManager simpleHttpConnMng = null;

    public HttpClientWebRequest(HttpConnectionManager simpleHttpConnMng) {
        this.simpleHttpConnMng = simpleHttpConnMng;
    }

    @Override
    public void close() {
        if (null != this.httpMethod) {
            this.httpMethod.releaseConnection();
        }
        this.httpMethod = null;
    }

    @Override
    public void prepareConnection() throws EWSHttpException {
        if (this.trustManger != null) {
            EwsSSLProtocolSocketFactory.trustManager = this.trustManger;
        }
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new EwsSSLProtocolSocketFactory(), 443));
        AuthPolicy.registerAuthScheme((String)"NTLM", EwsJCIFSNTLMScheme.class);
        this.client = new HttpClient(this.simpleHttpConnMng);
        ArrayList<String> authPrefs = new ArrayList<String>();
        authPrefs.add("NTLM");
        authPrefs.add("Basic");
        authPrefs.add("Digest");
        this.client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        if (this.getProxy() != null) {
            this.client.getHostConfiguration().setProxy(this.getProxy().getHost(), this.getProxy().getPort());
            if (HttpProxyCredentials.isProxySet()) {
                AuthScope authScope = new AuthScope(this.getProxy().getHost(), this.getProxy().getPort());
                this.client.getState().setProxyCredentials(authScope, (Credentials)new NTCredentials(HttpProxyCredentials.getUserName(), HttpProxyCredentials.getPassword(), "", HttpProxyCredentials.getDomain()));
            }
        }
        if (this.getUserName() != null) {
            this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(this.getUserName(), this.getPassword(), "", this.getDomain()));
        }
        this.client.getHttpConnectionManager().getParams().setSoTimeout(this.getTimeout());
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimeout());
        this.httpMethod = new PostMethod(this.getUrl().toString());
        this.httpMethod.setRequestHeader("Content-type", this.getContentType());
        this.httpMethod.setDoAuthentication(true);
        this.httpMethod.setRequestHeader("User-Agent", this.getUserAgent());
        this.httpMethod.setRequestHeader("Accept", this.getAccept());
        this.httpMethod.setRequestHeader("Keep-Alive", "300");
        this.httpMethod.setRequestHeader("Connection", "Keep-Alive");
        if (this.isAcceptGzipEncoding()) {
            this.httpMethod.setRequestHeader("Accept-Encoding", "gzip,deflate");
        }
        if (this.getHeaders().size() > 0) {
            for (Map.Entry<String, String> httpHeader : this.getHeaders().entrySet()) {
                this.httpMethod.setRequestHeader(httpHeader.getKey(), httpHeader.getValue());
            }
        }
    }

    @Override
    public void prepareAsyncConnection() throws EWSHttpException {
        try {
            if (this.trustManger != null) {
                EwsSSLProtocolSocketFactory.trustManager = this.trustManger;
            }
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new EwsSSLProtocolSocketFactory(), 443));
            AuthPolicy.registerAuthScheme((String)"NTLM", EwsJCIFSNTLMScheme.class);
            this.client = new HttpClient(this.simpleHttpConnMng);
            ArrayList<String> authPrefs = new ArrayList<String>();
            authPrefs.add("NTLM");
            authPrefs.add("Basic");
            authPrefs.add("Digest");
            this.client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
            this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(this.getUserName(), this.getPassword(), "", this.getDomain()));
            this.client.getHttpConnectionManager().getParams().setSoTimeout(this.getTimeout());
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(20000);
            this.httpMethod = new GetMethod(this.getUrl().toString());
            this.httpMethod.setFollowRedirects(this.isAllowAutoRedirect());
            int n = this.client.executeMethod((HttpMethod)this.httpMethod);
        }
        catch (IOException e) {
            this.client = null;
            this.httpMethod = null;
            throw new EWSHttpException("Unable to open connection to " + this.getUrl());
        }
    }

    @Override
    public InputStream getInputStream() throws EWSHttpException, IOException {
        this.throwIfConnIsNull();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.httpMethod.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw new EWSHttpException("Connection Error " + e);
        }
        return bufferedInputStream;
    }

    @Override
    public InputStream getErrorStream() throws EWSHttpException {
        this.throwIfConnIsNull();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.httpMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new EWSHttpException("Connection Error " + e);
        }
        return bufferedInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws EWSHttpException {
        ByteArrayOutputStream os = null;
        this.throwIfConnIsNull();
        os = new ByteArrayOutputStream();
        ((EntityEnclosingMethod)this.httpMethod).setRequestEntity((RequestEntity)new ByteArrayOSRequestEntity(os));
        return os;
    }

    @Override
    public Map<String, String> getResponseHeaders() throws EWSHttpException {
        Header[] hM;
        this.throwIfConnIsNull();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header header : hM = this.httpMethod.getResponseHeaders()) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }

    @Override
    public String getResponseHeaderField(String headerName) throws EWSHttpException {
        this.throwIfConnIsNull();
        Header hM = this.httpMethod.getResponseHeader(headerName);
        return hM != null ? hM.getValue() : null;
    }

    @Override
    public String getContentEncoding() throws EWSHttpException {
        this.throwIfConnIsNull();
        return this.httpMethod.getResponseHeader("content-encoding") != null ? this.httpMethod.getResponseHeader("content-encoding").getValue() : null;
    }

    @Override
    public String getResponseContentType() throws EWSHttpException {
        this.throwIfConnIsNull();
        return this.httpMethod.getResponseHeader("Content-type") != null ? this.httpMethod.getResponseHeader("Content-type").getValue() : null;
    }

    @Override
    public int executeRequest() throws EWSHttpException, HttpException, IOException {
        this.throwIfConnIsNull();
        return this.client.executeMethod((HttpMethod)this.httpMethod);
    }

    @Override
    public int getResponseCode() throws EWSHttpException {
        this.throwIfConnIsNull();
        return this.httpMethod.getStatusCode();
    }

    @Override
    public String getResponseText() throws EWSHttpException {
        this.throwIfConnIsNull();
        return this.httpMethod.getStatusText();
    }

    private void throwIfConnIsNull() throws EWSHttpException {
        if (null == this.httpMethod) {
            throw new EWSHttpException("Connection not established");
        }
    }

    @Override
    public Map<String, String> getRequestProperty() throws EWSHttpException {
        Header[] hM;
        this.throwIfConnIsNull();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header header : hM = this.httpMethod.getRequestHeaders()) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }

    @Override
    public void setClientCertificates(TrustManager certs) throws EWSHttpException {
        this.trustManger = certs;
    }
}

