/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import microsoft.exchange.webservices.data.Attachment;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.IServiceObjectChangedDelegate;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.Strings;

public class ItemAttachment
extends Attachment
implements IServiceObjectChangedDelegate {
    private Item item;

    protected ItemAttachment(Item owner) {
        super(owner);
    }

    public Item getItem() {
        return this.item;
    }

    protected void setItem(Item item) {
        this.throwIfThisIsNotNew();
        if (this.item != null) {
            this.item.removeServiceObjectChangedEvent(this);
        }
        this.item = item;
        if (this.item != null) {
            this.item.addServiceObjectChangedEvent(this);
        }
    }

    private void itemChanged(ServiceObject serviceObject) {
        this.item.getPropertyBag().changed();
    }

    @Override
    protected String getXmlElementName() {
        return "ItemAttachment";
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        boolean result = super.tryReadElementFromXml(reader);
        if (!result) {
            this.item = EwsUtilities.createItemFromXmlElementName(this, reader.getLocalName());
            if (this.item != null) {
                try {
                    this.item.loadFromXml(reader, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        try {
            this.item.writeToXml(writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void validate(int attachmentIndex) throws Exception {
        if (this.getName() == null || this.getName().isEmpty()) {
            try {
                throw new ServiceValidationException(String.format(Strings.ItemAttachmentMustBeNamed, attachmentIndex));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.validate();
        }
        catch (ServiceValidationException sve) {
            sve.printStackTrace();
        }
    }

    public void load(PropertyDefinitionBase ... additionalProperties) throws Exception {
        ArrayList<PropertyDefinitionBase> addProp = new ArrayList<PropertyDefinitionBase>();
        for (PropertyDefinitionBase addProperties1 : additionalProperties) {
            addProp.add(addProperties1);
        }
        this.internalLoad(null, addProp);
    }

    public void load(Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        this.internalLoad(null, additionalProperties);
    }

    public void load(BodyType bodyType, PropertyDefinitionBase ... additionalProperties) throws Exception {
        ArrayList<PropertyDefinitionBase> addProp = new ArrayList<PropertyDefinitionBase>();
        for (PropertyDefinitionBase addProperties1 : additionalProperties) {
            addProp.add(addProperties1);
        }
        this.internalLoad(bodyType, addProp);
    }

    public void load(BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        this.internalLoad(bodyType, additionalProperties);
    }

    @Override
    public void serviceObjectChanged(ServiceObject serviceObject) {
        this.itemChanged(serviceObject);
    }
}

