/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.TimeChange;
import microsoft.exchange.webservices.data.TimeSpan;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.XmlNamespace;

final class MeetingTimeZone
extends ComplexProperty {
    private String name;
    private TimeSpan baseOffset;
    private TimeChange standard;
    private TimeChange daylight;

    protected MeetingTimeZone(TimeZoneDefinition timeZone) {
        this.name = timeZone.getId();
    }

    public MeetingTimeZone() {
    }

    public MeetingTimeZone(String name) {
        this();
        this.name = name;
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("BaseOffset")) {
            this.baseOffset = EwsUtilities.getXSDurationToTimeSpan(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equals("Standard")) {
            this.standard = new TimeChange();
            this.standard.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("Daylight")) {
            this.daylight = new TimeChange();
            this.daylight.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        return false;
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.name = reader.readAttributeValue("TimeZoneName");
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("TimeZoneName", this.getName());
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.baseOffset != null) {
            writer.writeElementValue(XmlNamespace.Types, "BaseOffset", EwsUtilities.getTimeSpanToXSDuration(this.getBaseOffset()));
        }
        if (this.getStandard() != null) {
            this.getStandard().writeToXml(writer, "Standard");
        }
        if (this.getDaylight() != null) {
            this.getDaylight().writeToXml(writer, "Daylight");
        }
    }

    protected TimeZoneDefinition toTimeZoneInfo() {
        TimeZoneDefinition result = null;
        try {
            result = new TimeZoneDefinition();
            result.setId(this.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.canSetFieldValue(this.name, value)) {
            this.name = value;
            this.changed();
        }
    }

    public TimeSpan getBaseOffset() {
        return this.baseOffset;
    }

    public void setBaseOffset(TimeSpan value) {
        if (this.canSetFieldValue(this.name, value)) {
            this.baseOffset = value;
            this.changed();
        }
    }

    public TimeChange getStandard() {
        return this.standard;
    }

    public void setStandard(TimeChange value) {
        if (this.canSetFieldValue(this.standard, value)) {
            this.standard = value;
            this.changed();
        }
    }

    public TimeChange getDaylight() {
        return this.daylight;
    }

    public void setDaylight(TimeChange value) {
        if (this.canSetFieldValue(this.daylight, value)) {
            this.daylight = value;
            this.changed();
        }
    }
}

