/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;

public final class MessageBody
extends ComplexProperty {
    private BodyType bodyType;
    private String text;

    public MessageBody() {
    }

    public MessageBody(BodyType bodyType, String text) {
        this();
        this.bodyType = bodyType;
        this.text = text;
    }

    public MessageBody(String text) {
        this(BodyType.HTML, text);
    }

    public static MessageBody getMessageBodyFromText(String textBody) {
        return new MessageBody(BodyType.HTML, textBody);
    }

    public static String getStringFromMessageBody(MessageBody messageBody) throws Exception {
        EwsUtilities.validateParam(messageBody, "messageBody");
        return messageBody.text;
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.bodyType = reader.readAttributeValue(BodyType.class, "BodyType");
    }

    @Override
    protected void readTextValueFromXml(EwsServiceXmlReader reader) throws XMLStreamException, ServiceXmlDeserializationException {
        this.text = reader.readValue();
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("BodyType", (Object)this.getBodyType());
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        if (null != this.text && !this.text.isEmpty()) {
            writer.writeValue(this.getText(), "Body");
        }
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        if (this.canSetFieldValue(this.bodyType, bodyType)) {
            this.bodyType = bodyType;
            this.changed();
        }
    }

    private String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.canSetFieldValue(this.text, text)) {
            this.text = text;
            this.changed();
        }
    }

    public String toString() {
        return this.text == null ? "" : this.text;
    }
}

