/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class MoveCopyRequest<TServiceObject extends ServiceObject, TResponse extends ServiceResponse>
extends MultiResponseServiceRequest<TResponse> {
    private FolderId destinationFolderId;

    @Override
    protected void validate() throws Exception {
        EwsUtilities.validateParam(this.getDestinationFolderId(), "DestinationFolderId");
        this.getDestinationFolderId().validate(this.getService().getRequestedServerVersion());
    }

    protected MoveCopyRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    protected abstract void writeIdsToXml(EwsServiceXmlWriter var1) throws Exception;

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "ToFolderId");
        this.getDestinationFolderId().writeToXml(writer);
        writer.writeEndElement();
        this.writeIdsToXml(writer);
    }

    public FolderId getDestinationFolderId() {
        return this.destinationFolderId;
    }

    public void setDestinationFolderId(FolderId destinationFolderId) {
        this.destinationFolderId = destinationFolderId;
    }
}

