/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.DictionaryEntryProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.IPropertyBagChangedDelegate;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.PhysicalAddressKey;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.SimplePropertyBag;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class PhysicalAddressEntry
extends DictionaryEntryProperty<PhysicalAddressKey>
implements IPropertyBagChangedDelegate {
    private SimplePropertyBag<String> propertyBag = new SimplePropertyBag();

    public PhysicalAddressEntry() {
        super(PhysicalAddressKey.class);
        this.propertyBag.addOnChangeEvent(this);
    }

    public void propertyBagChanged(SimplePropertyBag simplePropertyBag) {
        this.changed();
    }

    public String getStreet() throws Exception {
        return (String)this.propertyBag.getSimplePropertyBag("Street");
    }

    public void setStreet(String value) throws Exception {
        this.propertyBag.setSimplePropertyBag("Street", value);
    }

    public String getCity() throws Exception {
        return (String)this.propertyBag.getSimplePropertyBag("City");
    }

    public void setCity(String value) {
        this.propertyBag.setSimplePropertyBag("City", value);
    }

    public String getState() throws Exception {
        return (String)this.propertyBag.getSimplePropertyBag("State");
    }

    public void setState(String value) {
        this.propertyBag.setSimplePropertyBag("State", value);
    }

    public String getCountryOrRegion() throws Exception {
        return (String)this.propertyBag.getSimplePropertyBag("CountryOrRegion");
    }

    public void setCountryOrRegion(String value) {
        this.propertyBag.setSimplePropertyBag("CountryOrRegion", value);
    }

    public String getPostalCode() {
        return (String)this.propertyBag.getSimplePropertyBag("PostalCode");
    }

    public void setPostalCode(String value) {
        this.propertyBag.setSimplePropertyBag("PostalCode", value);
    }

    @Override
    protected void clearChangeLog() {
        this.propertyBag.clearChangeLog();
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (PhysicalAddressSchema.getXmlElementNames().contains(reader.getLocalName())) {
            this.propertyBag.setSimplePropertyBag(reader.getLocalName(), reader.readElementValue());
            return true;
        }
        return false;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        for (String xmlElementName : PhysicalAddressSchema.getXmlElementNames()) {
            writer.writeElementValue(XmlNamespace.Types, xmlElementName, this.propertyBag.getSimplePropertyBag(xmlElementName));
        }
    }

    @Override
    protected boolean writeSetUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject, String ownerDictionaryXmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        ArrayList<String> fieldsToSet = new ArrayList<String>();
        for (String xmlElementName : this.propertyBag.getAddedItems()) {
            fieldsToSet.add(xmlElementName);
        }
        for (String xmlElementName : this.propertyBag.getModifiedItems()) {
            fieldsToSet.add(xmlElementName);
        }
        for (String xmlElementName : fieldsToSet) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getSetFieldXmlElementName());
            writer.writeStartElement(XmlNamespace.Types, "IndexedFieldURI");
            writer.writeAttributeValue("FieldURI", PhysicalAddressEntry.getFieldUri(xmlElementName));
            writer.writeAttributeValue("FieldIndex", ((PhysicalAddressKey)((Object)this.getKey())).toString());
            writer.writeEndElement();
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getXmlElementName());
            writer.writeStartElement(XmlNamespace.Types, ownerDictionaryXmlElementName);
            writer.writeStartElement(XmlNamespace.Types, "Entry");
            this.writeAttributesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, xmlElementName, this.propertyBag.getSimplePropertyBag(xmlElementName));
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (String xmlElementName : this.propertyBag.getRemovedItems()) {
            this.internalWriteDeleteFieldToXml(writer, ewsObject, xmlElementName);
        }
        return true;
    }

    @Override
    protected boolean writeDeleteUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject) throws XMLStreamException, ServiceXmlSerializationException {
        for (String xmlElementName : PhysicalAddressSchema.getXmlElementNames()) {
            this.internalWriteDeleteFieldToXml(writer, ewsObject, xmlElementName);
        }
        return true;
    }

    private static String getFieldUri(String xmlElementName) {
        return "contacts:PhysicalAddress:" + xmlElementName;
    }

    private void propertyBagChanged() {
        this.changed();
    }

    private void internalWriteDeleteFieldToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject, String fieldXmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, ewsObject.getDeleteFieldXmlElementName());
        writer.writeStartElement(XmlNamespace.Types, "IndexedFieldURI");
        writer.writeAttributeValue("FieldURI", PhysicalAddressEntry.getFieldUri(fieldXmlElementName));
        writer.writeAttributeValue("FieldIndex", ((PhysicalAddressKey)((Object)this.getKey())).toString());
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static class PhysicalAddressSchema {
        public static final String Street = "Street";
        public static final String City = "City";
        public static final String State = "State";
        public static final String CountryOrRegion = "CountryOrRegion";
        public static final String PostalCode = "PostalCode";
        private static LazyMember<List<String>> xmlElementNames = new LazyMember<List<String>>(new ILazyMember<List<String>>(){

            @Override
            public List<String> createInstance() {
                ArrayList<String> result = new ArrayList<String>();
                result.add(PhysicalAddressSchema.Street);
                result.add(PhysicalAddressSchema.City);
                result.add(PhysicalAddressSchema.State);
                result.add(PhysicalAddressSchema.CountryOrRegion);
                result.add(PhysicalAddressSchema.PostalCode);
                return result;
            }
        });

        private PhysicalAddressSchema() {
        }

        public static List<String> getXmlElementNames() {
            return xmlElementNames.getMember();
        }
    }
}

