/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Date;
import microsoft.exchange.webservices.data.Attachable;
import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EmailMessageSchema;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemAttachment;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.MessageBody;
import microsoft.exchange.webservices.data.PostItemSchema;
import microsoft.exchange.webservices.data.PostReply;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ResponseMessage;
import microsoft.exchange.webservices.data.ResponseMessageType;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.ServiceObjectSchema;

@Attachable
@ServiceObjectDefinition(xmlElementName="PostItem")
public final class PostItem
extends Item {
    public PostItem(ExchangeService service) throws Exception {
        super(service);
    }

    protected PostItem(ItemAttachment parentAttachment) throws Exception {
        super(parentAttachment);
    }

    public static PostItem bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(PostItem.class, id, propertySet);
    }

    public static PostItem bind(ExchangeService service, ItemId id) throws Exception {
        return PostItem.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    protected ServiceObjectSchema getSchema() {
        return PostItemSchema.Instance;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public PostReply createPostReply() throws Exception {
        this.throwIfThisIsNew();
        return new PostReply(this);
    }

    public void postReply(MessageBody bodyPrefix) throws Exception {
        PostReply postReply = this.createPostReply();
        postReply.setBodyPrefix(bodyPrefix);
        postReply.save();
    }

    public ResponseMessage createReply(boolean replyAll) throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, replyAll ? ResponseMessageType.ReplyAll : ResponseMessageType.Reply);
    }

    public void reply(MessageBody bodyPrefix, boolean replyAll) throws Exception {
        ResponseMessage responseMessage = this.createReply(replyAll);
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.sendAndSaveCopy();
    }

    public ResponseMessage createForward() throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, ResponseMessageType.Forward);
    }

    public void forward(MessageBody bodyPrefix, EmailAddress ... toRecipients) throws Exception {
        ArrayList<EmailAddress> list = new ArrayList<EmailAddress>();
        for (EmailAddress address : toRecipients) {
            list.add(address);
        }
        this.forward(bodyPrefix, list);
    }

    public void forward(MessageBody bodyPrefix, Iterable<EmailAddress> toRecipients) throws Exception {
        ResponseMessage responseMessage = this.createForward();
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.getToRecipients().addEmailRange(toRecipients.iterator());
        responseMessage.sendAndSaveCopy();
    }

    public byte[] getConversationIndex() throws ServiceLocalException {
        return (byte[])this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ConversationIndex);
    }

    public String getConversationTopic() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ConversationTopic);
    }

    public EmailAddress getFrom() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.From);
    }

    public void setFrom(EmailAddress value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.From, value);
    }

    public String getInternetMessageId() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.InternetMessageId);
    }

    public Boolean getIsRead() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsRead);
    }

    public void setIsRead(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsRead, value);
    }

    public Date getPostedTime() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(PostItemSchema.PostedTime);
    }

    public String getReferences() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.References);
    }

    public void setIsRead(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.References, value);
    }

    public EmailAddress getSender() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.Sender);
    }

    public void setSender(EmailAddress value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.Sender, value);
    }
}

