/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.List;
import microsoft.exchange.webservices.data.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.DeleteMode;
import microsoft.exchange.webservices.data.EmailMessageSchema;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.InvalidOperationException;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.ItemSchema;
import microsoft.exchange.webservices.data.MessageBody;
import microsoft.exchange.webservices.data.MessageDisposition;
import microsoft.exchange.webservices.data.PostItem;
import microsoft.exchange.webservices.data.PostReplySchema;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ResponseObjectSchema;
import microsoft.exchange.webservices.data.SendCancellationsMode;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.WellKnownFolderName;

@ServiceObjectDefinition(xmlElementName="PostReplyItem", returnedByServer=false)
public final class PostReply
extends ServiceObject {
    private Item referenceItem;

    protected PostReply(Item referenceItem) throws Exception {
        super(referenceItem.getService());
        EwsUtilities.EwsAssert(referenceItem != null, "PostReply.ctor", "referenceItem is null");
        referenceItem.throwIfThisIsNew();
        this.referenceItem = referenceItem;
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return PostReplySchema.Instance;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected PostItem internalCreate(FolderId parentFolderId, MessageDisposition messageDisposition) throws Exception {
        ((ItemId)this.getObjectFromPropertyDefinition(ResponseObjectSchema.ReferenceItemId)).assign(this.referenceItem.getId());
        List<Item> items = this.getService().internalCreateResponseObject(this, parentFolderId, messageDisposition);
        PostItem postItem = EwsUtilities.findFirstItemOfType(PostItem.class, items);
        EwsUtilities.EwsAssert(postItem != null, "PostReply.InternalCreate", "postItem is null. The CreateItem call did not return the expected PostItem.");
        return postItem;
    }

    @Override
    protected void internalLoad(PropertySet propertySet) throws InvalidOperationException {
        throw new InvalidOperationException(Strings.LoadingThisObjectTypeNotSupported);
    }

    @Override
    protected void internalDelete(DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) throws InvalidOperationException {
        throw new InvalidOperationException(Strings.DeletingThisObjectTypeNotAuthorized);
    }

    public PostItem save() throws Exception {
        return this.internalCreate(null, null);
    }

    public PostItem save(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.internalCreate(destinationFolderId, null);
    }

    public PostItem save(WellKnownFolderName destinationFolderName) throws Exception {
        return this.internalCreate(new FolderId(destinationFolderName), null);
    }

    public String getSubject() throws Exception {
        return (String)this.getObjectFromPropertyDefinition(EmailMessageSchema.Subject);
    }

    public void setSubject(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.Subject, value);
    }

    public MessageBody getBody() throws Exception {
        return (MessageBody)this.getObjectFromPropertyDefinition(ItemSchema.Body);
    }

    public void setBody(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Body, value);
    }

    public MessageBody getBodyPrefix() throws Exception {
        return (MessageBody)this.getObjectFromPropertyDefinition(ResponseObjectSchema.BodyPrefix);
    }

    public void setBodyPrefix(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ResponseObjectSchema.BodyPrefix, value);
    }
}

