/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.Recurrence;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class RecurrenceRange
extends ComplexProperty {
    private Date startDate;
    private Recurrence recurrence;

    protected RecurrenceRange() {
    }

    protected RecurrenceRange(Date startDate) {
        this();
        this.startDate = startDate;
    }

    @Override
    protected void changed() {
        if (this.recurrence != null) {
            this.recurrence.changed();
        }
    }

    protected void setupRecurrence(Recurrence recurrence) throws InstantiationException, IllegalAccessException, ServiceValidationException, Exception {
        recurrence.setStartDate(this.getStartDate());
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        Date d = this.startDate;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String formattedString = df.format(d);
        writer.writeElementValue(XmlNamespace.Types, "StartDate", formattedString);
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws ServiceXmlDeserializationException, InstantiationException, IllegalAccessException, XMLStreamException, ParseException, Exception {
        if (reader.getLocalName().equals("StartDate")) {
            Date startDate = reader.readElementValueAsUnspecifiedDate();
            if (startDate != null) {
                this.startDate = startDate;
                return true;
            }
            return false;
        }
        return false;
    }

    protected abstract String getXmlElementName();

    protected Recurrence getRecurrence() {
        return this.recurrence;
    }

    protected void setRecurrence(Recurrence value) {
        this.recurrence = value;
    }

    protected Date getStartDate() {
        return this.startDate;
    }

    protected void setStartDate(Date value) {
        this.canSetFieldValue(this.startDate, value);
    }
}

