/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.DelegateManagementRequestBase;
import microsoft.exchange.webservices.data.DelegateManagementResponse;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.UserId;
import microsoft.exchange.webservices.data.XmlNamespace;

class RemoveDelegateRequest
extends DelegateManagementRequestBase<DelegateManagementResponse> {
    private List<UserId> userIds = new ArrayList<UserId>();

    protected RemoveDelegateRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getUserIds().iterator(), "UserIds");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        writer.writeStartElement(XmlNamespace.Messages, "UserIds");
        for (UserId userId : this.getUserIds()) {
            userId.writeToXml(writer, "UserId");
        }
        writer.writeEndElement();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "RemoveDelegateResponse";
    }

    @Override
    protected String getXmlElementName() {
        return "RemoveDelegate";
    }

    @Override
    protected DelegateManagementResponse createResponse() {
        return new DelegateManagementResponse(false, null);
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public List<UserId> getUserIds() {
        return this.userIds;
    }
}

