/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.FolderIdCollection;
import microsoft.exchange.webservices.data.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.SearchFilter;
import microsoft.exchange.webservices.data.SearchFolderTraversal;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class SearchFolderParameters
extends ComplexProperty
implements IComplexPropertyChangedDelegate {
    private SearchFolderTraversal traversal;
    private FolderIdCollection rootFolderIds = new FolderIdCollection();
    private SearchFilter searchFilter;

    protected SearchFolderParameters() {
        this.rootFolderIds.addOnChangeEvent(this);
    }

    @Override
    public void complexPropertyChanged(ComplexProperty complexProperty) {
        this.propertyChanged(complexProperty);
    }

    private void propertyChanged(ComplexProperty complexProperty) {
        this.changed();
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("BaseFolderIds")) {
            this.rootFolderIds.internalClear();
            this.rootFolderIds.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("Restriction")) {
            reader.read();
            this.searchFilter = SearchFilter.loadFromXml(reader);
            return true;
        }
        return false;
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.traversal = reader.readAttributeValue(SearchFolderTraversal.class, "Traversal");
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Traversal", (Object)this.traversal);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.searchFilter != null) {
            writer.writeStartElement(XmlNamespace.Types, "Restriction");
            this.searchFilter.writeToXml(writer);
            writer.writeEndElement();
        }
        this.rootFolderIds.writeToXml(writer, "BaseFolderIds");
    }

    @Override
    public void validate() throws Exception {
        if (this.rootFolderIds.getCount() == 0) {
            throw new ServiceValidationException(Strings.SearchParametersRootFolderIdsEmpty);
        }
        if (this.searchFilter != null) {
            this.searchFilter.internalValidate();
        }
    }

    public SearchFolderTraversal getTraversal() {
        return this.traversal;
    }

    public void setTraversal(SearchFolderTraversal traversal) {
        if (this.canSetFieldValue(this.traversal, traversal)) {
            this.traversal = traversal;
            this.changed();
        }
    }

    public FolderIdCollection getRootFolderIds() {
        return this.rootFolderIds;
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(SearchFilter searchFilter) {
        if (this.searchFilter != null) {
            this.searchFilter.removeChangeEvent(this);
        }
        if (this.canSetFieldValue(this.searchFilter, searchFilter)) {
            this.searchFilter = searchFilter;
            this.changed();
        }
        if (this.searchFilter != null) {
            this.searchFilter.addOnChangeEvent(this);
        }
    }
}

