/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.OofSettings;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.XmlNamespace;

final class SetUserOofSettingsRequest
extends SimpleServiceRequestBase {
    private String smtpAddress;
    private OofSettings oofSettings;

    @Override
    protected String getXmlElementName() {
        return "SetUserOofSettingsRequest";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getSmtpAddress(), "SmtpAddress");
        EwsUtilities.validateParam(this.getOofSettings(), "OofSettings");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, "Mailbox");
        writer.writeElementValue(XmlNamespace.Types, "Address", this.getSmtpAddress());
        writer.writeEndElement();
        this.getOofSettings().writeToXml(writer, "UserOofSettings");
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SetUserOofSettingsResponse";
    }

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        ServiceResponse serviceResponse = new ServiceResponse();
        serviceResponse.loadFromXml(reader, "ResponseMessage");
        return serviceResponse;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected SetUserOofSettingsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    protected ServiceResponse execute() throws Exception {
        ServiceResponse serviceResponse = (ServiceResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return serviceResponse;
    }

    public String getSmtpAddress() {
        return this.smtpAddress;
    }

    public void setSmtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
    }

    public OofSettings getOofSettings() {
        return this.oofSettings;
    }

    public void setOofSettings(OofSettings oofSettings) {
        this.oofSettings = oofSettings;
    }
}

