/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EventType;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.FolderIdWrapperList;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.SubscribeResponse;
import microsoft.exchange.webservices.data.SubscriptionBase;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class SubscribeRequest<TSubscription extends SubscriptionBase>
extends MultiResponseServiceRequest<SubscribeResponse<TSubscription>> {
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();
    private List<EventType> eventTypes = new ArrayList<EventType>();
    private String watermark;

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getFolderIds(), "FolderIds");
        EwsUtilities.validateParamCollection(this.getEventTypes().iterator(), "EventTypes");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
        if (this.getEventTypes().contains((Object)EventType.Status)) {
            throw new ServiceValidationException(Strings.CannotSubscribeToStatusEvents);
        }
        if (this.getWatermark() != null && !this.getWatermark().isEmpty()) {
            EwsUtilities.validateNonBlankStringParam(this.getWatermark(), "Watermark");
        }
        for (EventType eventType : this.getEventTypes()) {
            EwsUtilities.validateEnumVersionValue(eventType, this.getService().getRequestedServerVersion());
        }
    }

    protected abstract String getSubscriptionXmlElementName();

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "Subscribe";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SubscribeResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "SubscribeResponseMessage";
    }

    protected abstract void internalWriteElementsToXml(EwsServiceXmlWriter var1) throws XMLStreamException, ServiceXmlSerializationException;

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, this.getSubscriptionXmlElementName());
        if (this.getFolderIds().getCount() == 0) {
            writer.writeAttributeValue("SubscribeToAllFolders", true);
        }
        this.getFolderIds().writeToXml(writer, XmlNamespace.Types, "FolderIds");
        writer.writeStartElement(XmlNamespace.Types, "EventTypes");
        for (EventType eventType : this.getEventTypes()) {
            writer.writeElementValue(XmlNamespace.Types, "EventType", (Object)eventType);
        }
        writer.writeEndElement();
        if (this.getWatermark() != null && !this.getWatermark().isEmpty()) {
            writer.writeElementValue(XmlNamespace.Types, "Watermark", this.getWatermark());
        }
        this.internalWriteElementsToXml(writer);
        writer.writeEndElement();
    }

    protected SubscribeRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
        this.setFolderIds(new FolderIdWrapperList());
        this.setEventTypes(new ArrayList<EventType>());
    }

    public FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }

    private void setFolderIds(FolderIdWrapperList value) {
        this.folderIds = value;
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    private void setEventTypes(List<EventType> value) {
        this.eventTypes = value;
    }

    public String getWatermark() {
        return this.watermark;
    }

    public void setWatermark(String watermark) {
        this.watermark = watermark;
    }
}

