/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.PullSubscription;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.SubscribeRequest;
import microsoft.exchange.webservices.data.SubscribeResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

class SubscribeToPullNotificationsRequest
extends SubscribeRequest<PullSubscription> {
    private int timeout = 30;

    protected SubscribeToPullNotificationsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeOut(int timeout) {
        this.timeout = timeout;
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        if (this.getTimeout() < 1 || this.getTimeout() > 1440) {
            throw new ArgumentException(String.format(Strings.InvalidTimeoutValue, this.getTimeout()));
        }
    }

    @Override
    protected SubscribeResponse<PullSubscription> createServiceResponse(ExchangeService service, int responseIndex) throws Exception {
        return new SubscribeResponse<PullSubscription>(new PullSubscription(service));
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    protected String getSubscriptionXmlElementName() {
        return "PullSubscriptionRequest";
    }

    @Override
    protected void internalWriteElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Types, "Timeout", this.getTimeout());
    }
}

