/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.StreamingSubscription;
import microsoft.exchange.webservices.data.SubscribeRequest;
import microsoft.exchange.webservices.data.SubscribeResponse;

class SubscribeToStreamingNotificationsRequest
extends SubscribeRequest<StreamingSubscription> {
    protected SubscribeToStreamingNotificationsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        if (this.getWatermark() != null && !this.getWatermark().isEmpty()) {
            throw new ArgumentException("Watermarks cannot be used with StreamingSubscriptions.");
        }
    }

    @Override
    protected String getSubscriptionXmlElementName() {
        return "StreamingSubscriptionRequest";
    }

    @Override
    protected void internalWriteElementsToXml(EwsServiceXmlWriter writer) {
    }

    @Override
    protected SubscribeResponse<StreamingSubscription> createServiceResponse(ExchangeService service, int responseIndex) throws Exception {
        return new SubscribeResponse<StreamingSubscription>(new StreamingSubscription(service));
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }
}

