/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.text.SimpleDateFormat;
import java.util.Date;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Time;
import microsoft.exchange.webservices.data.TimeChangeRecurrence;
import microsoft.exchange.webservices.data.TimeSpan;
import microsoft.exchange.webservices.data.XmlNamespace;

final class TimeChange
extends ComplexProperty {
    private String timeZoneName;
    private TimeSpan offset;
    private Time time;
    private Date absoluteDate;
    private TimeChangeRecurrence recurrence;

    public TimeChange() {
    }

    public TimeChange(TimeSpan offset) {
        this();
        this.offset = offset;
    }

    public TimeChange(TimeSpan offset, Time time) {
        this(offset);
        this.time = time;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public void setTimeZoneName(String timeZoneName) {
        this.timeZoneName = timeZoneName;
    }

    public TimeSpan getOffset() {
        return this.offset;
    }

    public void setOffset(TimeSpan offset) {
        this.offset = offset;
    }

    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public Date getAbsoluteDate() {
        return this.absoluteDate;
    }

    public void setAbsoluteDate(Date absoluteDate) {
        this.absoluteDate = absoluteDate;
        if (absoluteDate != null) {
            this.recurrence = null;
        }
    }

    public TimeChangeRecurrence getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(TimeChangeRecurrence recurrence) {
        this.recurrence = recurrence;
        if (this.recurrence != null) {
            this.absoluteDate = null;
        }
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("Offset")) {
            this.offset = EwsUtilities.getXSDurationToTimeSpan(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("RelativeYearlyRecurrence")) {
            this.recurrence = new TimeChangeRecurrence();
            this.recurrence.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("AbsoluteDate")) {
            Date tempDate;
            SimpleDateFormat sdfin = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.absoluteDate = tempDate = sdfin.parse(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("Time")) {
            SimpleDateFormat sdfin = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date tempDate = sdfin.parse(reader.readElementValue());
            this.time = new Time(tempDate);
            return true;
        }
        return false;
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.timeZoneName = reader.readAttributeValue("TimeZoneName");
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) {
        try {
            writer.writeAttributeValue("TimeZoneName", this.timeZoneName);
        }
        catch (ServiceXmlSerializationException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.offset != null) {
            writer.writeElementValue(XmlNamespace.Types, "Offset", EwsUtilities.getTimeSpanToXSDuration(this.getOffset()));
        }
        if (this.recurrence != null) {
            this.recurrence.writeToXml(writer, "RelativeYearlyRecurrence");
        }
        if (this.absoluteDate != null) {
            writer.writeElementValue(XmlNamespace.Types, "AbsoluteDate", EwsUtilities.dateTimeToXSDate(this.getAbsoluteDate()));
        }
        if (this.time != null) {
            writer.writeElementValue(XmlNamespace.Types, "Time", this.getTime().toXSTime());
        }
    }
}

