/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.Conflict;
import microsoft.exchange.webservices.data.ConflictType;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.SuggestionQuality;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class TimeSuggestion
extends ComplexProperty {
    private Date meetingTime;
    private boolean isWorkTime;
    private SuggestionQuality quality;
    private Collection<Conflict> conflicts = new ArrayList<Conflict>();

    protected TimeSuggestion() {
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("MeetingTime")) {
            this.meetingTime = reader.readElementValueAsUnbiasedDateTimeScopedToServiceTimeZone();
            return true;
        }
        if (reader.getLocalName().equals("IsWorkTime")) {
            this.isWorkTime = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("SuggestionQuality")) {
            this.quality = reader.readElementValue(SuggestionQuality.class);
            return true;
        }
        if (reader.getLocalName().equals("AttendeeConflictDataArray")) {
            if (!reader.isEmptyElement()) {
                do {
                    reader.read();
                    if (!reader.isStartElement()) continue;
                    Conflict conflict = null;
                    if (reader.getLocalName().equals("UnknownAttendeeConflictData")) {
                        conflict = new Conflict(ConflictType.UnknownAttendeeConflict);
                    } else if (reader.getLocalName().equals("TooBigGroupAttendeeConflictData")) {
                        conflict = new Conflict(ConflictType.GroupTooBigConflict);
                    } else if (reader.getLocalName().equals("IndividualAttendeeConflictData")) {
                        conflict = new Conflict(ConflictType.IndividualAttendeeConflict);
                    } else if (reader.getLocalName().equals("GroupAttendeeConflictData")) {
                        conflict = new Conflict(ConflictType.GroupConflict);
                    } else {
                        EwsUtilities.EwsAssert(false, "TimeSuggestion.TryReadElementFromXml", String.format("The %s element name does not map to any AttendeeConflict descendant.", reader.getLocalName()));
                    }
                    conflict.loadFromXml(reader, reader.getLocalName());
                    this.conflicts.add(conflict);
                } while (!reader.isEndElement(XmlNamespace.Types, "AttendeeConflictDataArray"));
            }
            return true;
        }
        return false;
    }

    public Date getMeetingTime() {
        return this.meetingTime;
    }

    public boolean isWorkTime() {
        return this.isWorkTime;
    }

    public SuggestionQuality getQuality() {
        return this.quality;
    }

    public Collection<Conflict> getConflicts() {
        return this.conflicts;
    }
}

