/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AbsoluteDateTransition;
import microsoft.exchange.webservices.data.AbsoluteDayOfMonthTransition;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.RelativeDayOfMonthTransition;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.TimeZonePeriod;
import microsoft.exchange.webservices.data.TimeZoneTransitionGroup;
import microsoft.exchange.webservices.data.XmlNamespace;

class TimeZoneTransition
extends ComplexProperty {
    private final String PeriodTarget = "Period";
    private final String GroupTarget = "Group";
    private TimeZoneDefinition timeZoneDefinition;
    private TimeZonePeriod targetPeriod;
    private TimeZoneTransitionGroup targetGroup;

    protected static TimeZoneTransition create(TimeZoneDefinition timeZoneDefinition, String xmlElementName) throws ServiceLocalException {
        if (xmlElementName.equals("AbsoluteDateTransition")) {
            return new AbsoluteDateTransition(timeZoneDefinition);
        }
        if (xmlElementName.equals("AbsoluteDateTransition")) {
            return new AbsoluteDateTransition(timeZoneDefinition);
        }
        if (xmlElementName.equals("RecurringDayTransition")) {
            return new RelativeDayOfMonthTransition(timeZoneDefinition);
        }
        if (xmlElementName.equals("RecurringDateTransition")) {
            return new AbsoluteDayOfMonthTransition(timeZoneDefinition);
        }
        if (xmlElementName.equals("Transition")) {
            return new TimeZoneTransition(timeZoneDefinition);
        }
        throw new ServiceLocalException(String.format(Strings.UnknownTimeZonePeriodTransitionType, xmlElementName));
    }

    protected String getXmlElementName() {
        return "Transition";
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("To")) {
            String targetKind = reader.readAttributeValue("Kind");
            String targetId = reader.readElementValue();
            if (targetKind.equals("Period")) {
                if (!this.timeZoneDefinition.getPeriods().containsKey(targetId)) {
                    this.targetPeriod = this.timeZoneDefinition.getPeriods().get(targetId);
                    throw new ServiceLocalException(String.format(Strings.PeriodNotFound, targetId));
                }
            } else if (targetKind.equals("Group")) {
                if (!this.timeZoneDefinition.getTransitionGroups().containsKey(targetId)) {
                    this.targetGroup = this.timeZoneDefinition.getTransitionGroups().get(targetId);
                    throw new ServiceLocalException(String.format(Strings.TransitionGroupNotFound, targetId));
                }
            } else {
                throw new ServiceLocalException(Strings.UnsupportedTimeZonePeriodTransitionTarget);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeStartElement(XmlNamespace.Types, "To");
        if (this.targetPeriod != null) {
            writer.writeAttributeValue("Kind", "Period");
            writer.writeValue(this.targetPeriod.getId(), "To");
        } else {
            writer.writeAttributeValue("Kind", "Group");
            writer.writeValue(this.targetGroup.getId(), "To");
        }
        writer.writeEndElement();
    }

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        this.loadFromXml(reader, this.getXmlElementName());
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.writeToXml(writer, this.getXmlElementName());
    }

    protected TimeZoneTransition(TimeZoneDefinition timeZoneDefinition) {
        this.timeZoneDefinition = timeZoneDefinition;
    }

    protected TimeZoneTransition(TimeZoneDefinition timeZoneDefinition, TimeZoneTransitionGroup targetGroup) {
        this(timeZoneDefinition);
        this.targetGroup = targetGroup;
    }

    protected TimeZoneTransition(TimeZoneDefinition timeZoneDefinition, TimeZonePeriod targetPeriod) {
        this(timeZoneDefinition);
        this.targetPeriod = targetPeriod;
    }

    protected TimeZonePeriod getTargetPeriod() {
        return this.targetPeriod;
    }

    protected TimeZoneTransitionGroup getTargetGroup() {
        return this.targetGroup;
    }
}

