/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.text.ParseException;
import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.PropertyBag;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class TypedPropertyDefinition
extends PropertyDefinition {
    private boolean isNullable;

    protected TypedPropertyDefinition(String xmlElementName, String uri, ExchangeVersion version) {
        super(xmlElementName, uri, version);
        this.isNullable = false;
    }

    protected TypedPropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    protected TypedPropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, boolean isNullable) {
        super(xmlElementName, uri, flags, version);
        this.isNullable = isNullable;
    }

    protected abstract Object parse(String var1) throws InstantiationException, IllegalAccessException, ParseException;

    @Override
    protected boolean isNullable() {
        return this.isNullable;
    }

    protected String toString(Object value) {
        return value.toString();
    }

    @Override
    protected void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        String value = reader.readElementValue(XmlNamespace.Types, this.getXmlElement());
        if (value != null && !value.isEmpty()) {
            propertyBag.setObjectFromPropertyDefinition(this, this.parse(value));
        }
    }

    @Override
    protected void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws XMLStreamException, ServiceXmlSerializationException, ServiceLocalException {
        Object value = propertyBag.getObjectFromPropertyDefinition(this);
        if (value != null) {
            writer.writeElementValue(XmlNamespace.Types, this.getXmlElement(), this.getName(), value);
        }
    }
}

