/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.config;

import com.mybatisflex.codegen.config.ColumnConfig;
import com.mybatisflex.codegen.config.TableConfig;
import com.mybatisflex.core.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StrategyConfig {
    private String tablePrefix;
    private String logicDeleteColumn;
    private String versionColumn;
    private boolean generateForView;
    private Map<String, TableConfig> tableConfigMap;
    private Map<String, ColumnConfig> columnConfigMap;
    private String generateSchema;
    private Set<String> generateTables;
    private Set<String> unGenerateTables;
    private Set<String> ignoreColumns;

    public Set<String> getIgnoreColumns() {
        return this.ignoreColumns;
    }

    public StrategyConfig setIgnoreColumns(String ... columns) {
        if (this.ignoreColumns == null) {
            this.ignoreColumns = new HashSet<String>();
        }
        for (String column : columns) {
            if (column == null || column.trim().isEmpty()) continue;
            this.ignoreColumns.add(column.trim().toLowerCase());
        }
        return this;
    }

    public String getGenerateSchema() {
        return this.generateSchema;
    }

    public StrategyConfig setGenerateSchema(String generateSchema) {
        this.generateSchema = generateSchema;
        return this;
    }

    public TableConfig getTableConfig(String tableName) {
        if (this.tableConfigMap == null) {
            return null;
        }
        TableConfig tableConfig = this.tableConfigMap.get(tableName);
        return tableConfig != null ? tableConfig : this.tableConfigMap.get("*");
    }

    public StrategyConfig setTableConfig(TableConfig tableConfig) {
        if (this.tableConfigMap == null) {
            this.tableConfigMap = new HashMap<String, TableConfig>();
        }
        this.tableConfigMap.put(tableConfig.getTableName(), tableConfig);
        return this;
    }

    public ColumnConfig getColumnConfig(String tableName, String columnName) {
        ColumnConfig columnConfig = null;
        TableConfig tableConfig = this.getTableConfig(tableName);
        if (tableConfig != null) {
            columnConfig = tableConfig.getColumnConfig(columnName);
        }
        if (columnConfig == null && this.columnConfigMap != null) {
            columnConfig = this.columnConfigMap.get(columnName);
        }
        if (columnConfig == null) {
            columnConfig = new ColumnConfig();
        }
        if (columnName.equals(this.logicDeleteColumn) && columnConfig.getLogicDelete() == null) {
            columnConfig.setLogicDelete(true);
        }
        if (columnName.equals(this.versionColumn) && columnConfig.getVersion() == null) {
            columnConfig.setVersion(true);
        }
        return columnConfig;
    }

    public StrategyConfig setColumnConfig(ColumnConfig columnConfig) {
        if (this.columnConfigMap == null) {
            this.columnConfigMap = new HashMap<String, ColumnConfig>();
        }
        this.columnConfigMap.put(columnConfig.getColumnName(), columnConfig);
        return this;
    }

    public StrategyConfig setColumnConfig(String tableName, ColumnConfig columnConfig) {
        TableConfig tableConfig = this.getTableConfig(tableName);
        if (tableConfig == null) {
            tableConfig = new TableConfig();
            tableConfig.setTableName(tableName);
            this.setTableConfig(tableConfig);
        }
        tableConfig.setColumnConfig(columnConfig);
        return this;
    }

    public StrategyConfig setGenerateTable(String ... tables) {
        if (this.generateTables == null) {
            this.generateTables = new HashSet<String>();
        }
        for (String table : tables) {
            if (table == null || table.trim().isEmpty()) continue;
            this.generateTables.add(table.trim());
        }
        return this;
    }

    public StrategyConfig setUnGenerateTable(String ... tables) {
        if (this.unGenerateTables == null) {
            this.unGenerateTables = new HashSet<String>();
        }
        for (String table : tables) {
            if (table == null || table.trim().isEmpty()) continue;
            this.unGenerateTables.add(table.trim());
        }
        return this;
    }

    public boolean isSupportGenerate(String table) {
        if (this.unGenerateTables != null && this.unGenerateTables.contains(table)) {
            return false;
        }
        if (this.generateTables == null || this.generateTables.isEmpty()) {
            return true;
        }
        for (String generateTable : this.generateTables) {
            if (!generateTable.equals(table)) continue;
            return true;
        }
        return false;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public StrategyConfig setTablePrefix(String ... tablePrefix) {
        this.tablePrefix = StringUtil.join((String)",", (CharSequence[])tablePrefix);
        return this;
    }

    public String getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    public StrategyConfig setLogicDeleteColumn(String logicDeleteColumn) {
        this.logicDeleteColumn = logicDeleteColumn;
        return this;
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public StrategyConfig setVersionColumn(String versionColumn) {
        this.versionColumn = versionColumn;
        return this;
    }

    public boolean isGenerateForView() {
        return this.generateForView;
    }

    public StrategyConfig setGenerateForView(boolean generateForView) {
        this.generateForView = generateForView;
        return this;
    }

    public Map<String, TableConfig> getTableConfigMap() {
        return this.tableConfigMap;
    }

    public StrategyConfig setTableConfigMap(Map<String, TableConfig> tableConfigMap) {
        this.tableConfigMap = tableConfigMap;
        return this;
    }

    public Map<String, ColumnConfig> getColumnConfigMap() {
        return this.columnConfigMap;
    }

    public StrategyConfig setColumnConfigMap(Map<String, ColumnConfig> columnConfigMap) {
        this.columnConfigMap = columnConfigMap;
        return this;
    }

    public Set<String> getGenerateTables() {
        return this.generateTables;
    }

    public StrategyConfig setGenerateTables(Set<String> generateTables) {
        this.generateTables = generateTables;
        return this;
    }

    public Set<String> getUnGenerateTables() {
        return this.unGenerateTables;
    }

    public StrategyConfig setUnGenerateTables(Set<String> unGenerateTables) {
        this.unGenerateTables = unGenerateTables;
        return this;
    }
}

