/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.config;

import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.codegen.config.ColumnConfig;
import java.util.HashMap;
import java.util.Map;

public class TableConfig {
    public static final String ALL_TABLES = "*";
    private String schema;
    private String tableName = "*";
    private Boolean camelToUnderline;
    private Class<? extends InsertListener> insertListenerClass;
    private Class<? extends UpdateListener> updateListenerClass;
    private Class<? extends SetListener> setListenerClass;
    private Boolean mapperGenerateEnable = Boolean.TRUE;
    private Map<String, ColumnConfig> columnConfigMap;

    public static TableConfig create() {
        return new TableConfig();
    }

    public String getSchema() {
        return this.schema;
    }

    public TableConfig setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableConfig setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Boolean getCamelToUnderline() {
        return this.camelToUnderline;
    }

    public TableConfig setCamelToUnderline(Boolean camelToUnderline) {
        this.camelToUnderline = camelToUnderline;
        return this;
    }

    public Class<? extends InsertListener> getInsertListenerClass() {
        return this.insertListenerClass;
    }

    public TableConfig setInsertListenerClass(Class<? extends InsertListener> insertListenerClass) {
        this.insertListenerClass = insertListenerClass;
        return this;
    }

    public Class<? extends UpdateListener> getUpdateListenerClass() {
        return this.updateListenerClass;
    }

    public TableConfig setUpdateListenerClass(Class<? extends UpdateListener> updateListenerClass) {
        this.updateListenerClass = updateListenerClass;
        return this;
    }

    public Class<? extends SetListener> getSetListenerClass() {
        return this.setListenerClass;
    }

    public TableConfig setSetListenerClass(Class<? extends SetListener> setListenerClass) {
        this.setListenerClass = setListenerClass;
        return this;
    }

    public Boolean getMapperGenerateEnable() {
        return this.mapperGenerateEnable;
    }

    public TableConfig setMapperGenerateEnable(Boolean mapperGenerateEnable) {
        this.mapperGenerateEnable = mapperGenerateEnable;
        return this;
    }

    public Map<String, ColumnConfig> getColumnConfigMap() {
        return this.columnConfigMap;
    }

    public TableConfig setColumnConfigMap(Map<String, ColumnConfig> columnConfigMap) {
        this.columnConfigMap = columnConfigMap;
        return this;
    }

    public TableConfig setColumnConfig(ColumnConfig columnConfig) {
        if (this.columnConfigMap == null) {
            this.columnConfigMap = new HashMap<String, ColumnConfig>();
        }
        this.columnConfigMap.put(columnConfig.getColumnName(), columnConfig);
        return this;
    }

    protected ColumnConfig getColumnConfig(String columnName) {
        return this.columnConfigMap == null ? null : this.columnConfigMap.get(columnName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final TableConfig tableConfig = new TableConfig();

        private Builder() {
        }

        public Builder schema(String schema) {
            this.tableConfig.setSchema(schema);
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableConfig.setTableName(tableName);
            return this;
        }

        public Builder camelToUnderline(Boolean camelToUnderline) {
            this.tableConfig.setCamelToUnderline(camelToUnderline);
            return this;
        }

        public Builder insertListenerClass(Class<? extends InsertListener> insertListenerClass) {
            this.tableConfig.setInsertListenerClass(insertListenerClass);
            return this;
        }

        public Builder updateListenerClass(Class<? extends UpdateListener> updateListenerClass) {
            this.tableConfig.setUpdateListenerClass(updateListenerClass);
            return this;
        }

        public Builder setListenerClass(Class<? extends SetListener> setListenerClass) {
            this.tableConfig.setSetListenerClass(setListenerClass);
            return this;
        }

        public Builder mapperGenerateEnable(Boolean mapperGenerateEnable) {
            this.tableConfig.setMapperGenerateEnable(mapperGenerateEnable);
            return this;
        }

        public Builder columnConfig(ColumnConfig columnConfigMap) {
            this.tableConfig.setColumnConfig(columnConfigMap);
            return this;
        }

        public TableConfig build() {
            return this.tableConfig;
        }
    }
}

