/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.dialect;

import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.dialect.IDialect;
import com.mybatisflex.codegen.entity.Column;
import com.mybatisflex.codegen.entity.Table;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SqliteDialect
implements IDialect {
    @Override
    public void buildTableColumns(String schemaName, Table table, GlobalConfig globalConfig, DatabaseMetaData dbMeta, Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery("pragma table_info(" + table.getName() + ")");
        while (rs.next()) {
            Column column = new Column();
            column.setName(rs.getString(2));
            String type = rs.getString(3);
            column.setPropertyType(this.type2ClassName(type));
            table.addColumn(column);
        }
    }

    @Override
    public ResultSet getTablesResultSet(DatabaseMetaData dbMeta, Connection conn, String schema, String[] types) throws SQLException {
        return dbMeta.getTables(conn.getCatalog(), schema, null, types);
    }

    private String type2ClassName(String type) {
        int indexOf = type.indexOf("(");
        if (indexOf > 0) {
            type = type.substring(0, indexOf);
        }
        switch (type = type.toLowerCase()) {
            case "integer": 
            case "int": 
            case "int2": 
            case "int8": 
            case "tinyint": 
            case "smallint": 
            case "mediumint": {
                return Integer.class.getName();
            }
            case "bigint": 
            case "unsigned bigint": {
                return BigInteger.class.getName();
            }
            case "character": 
            case "varchar": 
            case "nchar": 
            case "nvarchar": 
            case "varying character": 
            case "native character": 
            case "text": 
            case "clob": {
                return String.class.getName();
            }
            case "double": 
            case "numeric": 
            case "real": {
                return Double.class.getName();
            }
            case "float": {
                return Float.class.getName();
            }
            case "decimal": {
                return BigDecimal.class.getName();
            }
        }
        return String.class.getName();
    }
}

