/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.entity;

import com.mybatisflex.codegen.config.ControllerConfig;
import com.mybatisflex.codegen.config.EntityConfig;
import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.config.MapperConfig;
import com.mybatisflex.codegen.config.MapperXmlConfig;
import com.mybatisflex.codegen.config.ServiceConfig;
import com.mybatisflex.codegen.config.ServiceImplConfig;
import com.mybatisflex.codegen.config.TableConfig;
import com.mybatisflex.codegen.config.TableDefConfig;
import com.mybatisflex.codegen.entity.Column;
import com.mybatisflex.core.util.StringUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Table {
    private String name;
    private String schema;
    private String comment;
    private Set<String> primaryKeys;
    private List<Column> columns = new ArrayList<Column>();
    private TableConfig tableConfig;
    private GlobalConfig globalConfig;

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        if (StringUtil.isNotBlank((String)this.comment)) {
            return this.globalConfig.getJavadocConfig().formatTableComment(this.comment);
        }
        return null;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getPrimaryKey() {
        return this.columns.stream().filter(Column::isPrimaryKey).findFirst().map(Column::getProperty).orElse(null);
    }

    public Set<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(Set<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void addPrimaryKey(String primaryKey) {
        if (this.primaryKeys == null) {
            this.primaryKeys = new LinkedHashSet<String>();
        }
        this.primaryKeys.add(primaryKey);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Column> getSortedColumns() {
        ArrayList<Column> arrayList = new ArrayList<Column>(this.columns);
        arrayList.sort(Comparator.comparingInt(c -> c.getProperty().length()).thenComparing(Column::getProperty));
        return arrayList;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void addColumn(Column column) {
        if (this.primaryKeys != null && this.primaryKeys.contains(column.getName())) {
            column.setPrimaryKey(true);
            if (column.getAutoIncrement() == null && (column.getPropertyType().equals(Integer.class.getName()) || column.getPropertyType().equals(BigInteger.class.getName()))) {
                column.setAutoIncrement(true);
            }
        }
        if (column.getAutoIncrement() == null) {
            column.setAutoIncrement(false);
        }
        column.setColumnConfig(this.globalConfig.getStrategyConfig().getColumnConfig(this.name, column.getName()));
        this.columns.add(column);
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    public List<String> buildImports() {
        HashSet<String> imports = new HashSet<String>();
        imports.add("com.mybatisflex.annotation.Table");
        for (Column column : this.columns) {
            imports.addAll(column.getImportClasses());
        }
        EntityConfig entityConfig = this.globalConfig.getEntityConfig();
        if (entityConfig.getSuperClass() != null) {
            imports.add(entityConfig.getSuperClass().getName());
        }
        if (entityConfig.getImplInterfaces() != null) {
            for (Class<?> entityInterface : entityConfig.getImplInterfaces()) {
                imports.add(entityInterface.getName());
            }
        }
        if (this.tableConfig != null) {
            if (this.tableConfig.getInsertListenerClass() != null) {
                imports.add(this.tableConfig.getInsertListenerClass().getName());
            }
            if (this.tableConfig.getUpdateListenerClass() != null) {
                imports.add(this.tableConfig.getUpdateListenerClass().getName());
            }
            if (this.tableConfig.getSetListenerClass() != null) {
                imports.add(this.tableConfig.getSetListenerClass().getName());
            }
        }
        return imports.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    public String buildTableAnnotation() {
        String dataSource;
        StringBuilder tableAnnotation = new StringBuilder();
        tableAnnotation.append("@Table(value = \"").append(this.name).append("\"");
        String globalSchema = this.tableConfig == null ? this.schema : (StringUtil.isBlank((String)this.tableConfig.getSchema()) ? this.schema : null);
        if (StringUtil.isNotBlank((String)globalSchema)) {
            tableAnnotation.append(", schema = \"").append(globalSchema).append("\"");
        }
        if (StringUtil.isNotBlank((String)(dataSource = this.globalConfig.getEntityDataSource()))) {
            tableAnnotation.append(", dataSource = \"").append(dataSource).append("\"");
        }
        if (this.tableConfig != null) {
            if (StringUtil.isNotBlank((String)this.tableConfig.getSchema())) {
                tableAnnotation.append(", schema = \"").append(this.tableConfig.getSchema()).append("\"");
            }
            if (this.tableConfig.getCamelToUnderline() != null) {
                tableAnnotation.append(", camelToUnderline = ").append(this.tableConfig.getCamelToUnderline());
            }
            if (this.tableConfig.getInsertListenerClass() != null) {
                tableAnnotation.append(", onInsert = ").append(this.tableConfig.getInsertListenerClass().getSimpleName()).append(".class");
            }
            if (this.tableConfig.getUpdateListenerClass() != null) {
                tableAnnotation.append(", onUpdate = ").append(this.tableConfig.getUpdateListenerClass().getSimpleName()).append(".class");
            }
            if (this.tableConfig.getSetListenerClass() != null) {
                tableAnnotation.append(", onSet = ").append(this.tableConfig.getSetListenerClass().getSimpleName()).append(".class");
            }
            if (Boolean.FALSE.equals(this.tableConfig.getMapperGenerateEnable())) {
                tableAnnotation.append(", mapperGenerateEnable = false");
            }
        }
        return tableAnnotation.append(")").toString();
    }

    public String buildExtends() {
        EntityConfig entityConfig = this.globalConfig.getEntityConfig();
        if (entityConfig.getSuperClass() != null) {
            return " extends " + entityConfig.getSuperClass().getSimpleName();
        }
        return "";
    }

    public String buildImplements() {
        Class<?>[] entityInterfaces = this.globalConfig.getEntityConfig().getImplInterfaces();
        if (entityInterfaces != null && entityInterfaces.length > 0) {
            return " implements " + StringUtil.join((String)", ", (Collection)Arrays.stream(entityInterfaces).map(Class::getSimpleName).collect(Collectors.toList()));
        }
        return "";
    }

    public String getEntityJavaFileName() {
        String entityJavaFileName = this.name;
        String tablePrefix = this.globalConfig.getStrategyConfig().getTablePrefix();
        if (tablePrefix != null) {
            String[] tablePrefixes;
            for (String prefix : tablePrefixes = tablePrefix.split(",")) {
                String trimPrefix = prefix.trim();
                if (trimPrefix.length() <= 0 || !this.name.startsWith(trimPrefix)) continue;
                entityJavaFileName = this.name.substring(trimPrefix.length());
                break;
            }
        }
        return StringUtil.firstCharToUpperCase((String)StringUtil.underlineToCamel((String)entityJavaFileName));
    }

    public String buildEntityClassName() {
        String entityJavaFileName = this.getEntityJavaFileName();
        EntityConfig entityConfig = this.globalConfig.getEntityConfig();
        return entityConfig.getClassPrefix() + entityJavaFileName + entityConfig.getClassSuffix();
    }

    public String buildTableDefClassName() {
        String tableDefJavaFileName = this.getEntityJavaFileName();
        TableDefConfig tableDefConfig = this.globalConfig.getTableDefConfig();
        return tableDefConfig.getClassPrefix() + tableDefJavaFileName + tableDefConfig.getClassSuffix();
    }

    public String buildMapperClassName() {
        String entityJavaFileName = this.getEntityJavaFileName();
        MapperConfig mapperConfig = this.globalConfig.getMapperConfig();
        return mapperConfig.getClassPrefix() + entityJavaFileName + mapperConfig.getClassSuffix();
    }

    public String buildServiceClassName() {
        String entityJavaFileName = this.getEntityJavaFileName();
        ServiceConfig serviceConfig = this.globalConfig.getServiceConfig();
        return serviceConfig.getClassPrefix() + entityJavaFileName + serviceConfig.getClassSuffix();
    }

    public String buildServiceImplClassName() {
        String entityJavaFileName = this.getEntityJavaFileName();
        ServiceImplConfig serviceImplConfig = this.globalConfig.getServiceImplConfig();
        return serviceImplConfig.getClassPrefix() + entityJavaFileName + serviceImplConfig.getClassSuffix();
    }

    public String buildControllerClassName() {
        String entityJavaFileName = this.getEntityJavaFileName();
        ControllerConfig controllerConfig = this.globalConfig.getControllerConfig();
        return controllerConfig.getClassPrefix() + entityJavaFileName + controllerConfig.getClassSuffix();
    }

    public String buildMapperXmlFileName() {
        String tableDefJavaFileName = this.getEntityJavaFileName();
        MapperXmlConfig mapperXmlConfig = this.globalConfig.getMapperXmlConfig();
        return mapperXmlConfig.getFilePrefix() + tableDefJavaFileName + mapperXmlConfig.getFileSuffix();
    }

    public String toString() {
        return "Table{schema'" + this.schema + '\'' + "name='" + this.name + '\'' + ", remarks='" + this.comment + '\'' + ", primaryKeys='" + this.primaryKeys + '\'' + ", columns=" + this.columns + '}';
    }
}

