/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.generator.impl;

import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.config.MapperXmlConfig;
import com.mybatisflex.codegen.config.PackageConfig;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.codegen.generator.IGenerator;
import java.io.File;
import java.util.HashMap;

public class MapperXmlGenerator
implements IGenerator {
    private String templatePath;

    public MapperXmlGenerator() {
        this("/templates/enjoy/mapperXml.tpl");
    }

    public MapperXmlGenerator(String templatePath) {
        this.templatePath = templatePath;
    }

    @Override
    public void generate(Table table, GlobalConfig globalConfig) {
        if (!globalConfig.isMapperXmlGenerateEnable()) {
            return;
        }
        PackageConfig packageConfig = globalConfig.getPackageConfig();
        MapperXmlConfig mapperXmlConfig = globalConfig.getMapperXmlConfig();
        File mapperXmlFile = new File(packageConfig.getMapperXmlPath() + "/" + table.buildMapperXmlFileName() + ".xml");
        if (mapperXmlFile.exists() && !mapperXmlConfig.isOverwriteEnable()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("table", table);
        params.put("packageConfig", packageConfig);
        params.putAll(globalConfig.getCustomConfig());
        globalConfig.getTemplateConfig().getTemplate().generate(params, this.templatePath, mapperXmlFile);
        System.out.println("MapperXML ---> " + mapperXmlFile);
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }
}

