/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.generator.impl;

import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.config.PackageConfig;
import com.mybatisflex.codegen.config.ServiceImplConfig;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.codegen.generator.IGenerator;
import java.io.File;
import java.util.HashMap;

public class ServiceImplGenerator
implements IGenerator {
    private String templatePath;

    public ServiceImplGenerator() {
        this("/templates/enjoy/serviceImpl.tpl");
    }

    public ServiceImplGenerator(String templatePath) {
        this.templatePath = templatePath;
    }

    @Override
    public void generate(Table table, GlobalConfig globalConfig) {
        if (!globalConfig.isServiceImplGenerateEnable()) {
            return;
        }
        PackageConfig packageConfig = globalConfig.getPackageConfig();
        ServiceImplConfig serviceImplConfig = globalConfig.getServiceImplConfig();
        String serviceImplPackagePath = packageConfig.getServiceImplPackage().replace(".", "/");
        File serviceImplJavaFile = new File(packageConfig.getSourceDir(), serviceImplPackagePath + "/" + table.buildServiceImplClassName() + ".java");
        if (serviceImplJavaFile.exists() && !serviceImplConfig.isOverwriteEnable()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("table", table);
        params.put("packageConfig", packageConfig);
        params.put("serviceImplConfig", serviceImplConfig);
        params.put("javadocConfig", globalConfig.getJavadocConfig());
        params.putAll(globalConfig.getCustomConfig());
        globalConfig.getTemplateConfig().getTemplate().generate(params, this.templatePath, serviceImplJavaFile);
        System.out.println("ServiceImpl ---> " + serviceImplJavaFile);
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }
}

