/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource;

import com.mybatisflex.core.datasource.DataSourceDecipher;
import com.mybatisflex.core.datasource.DataSourceProperty;
import com.mybatisflex.core.datasource.DataSourceShardingStrategy;
import com.mybatisflex.core.datasource.processor.DataSourceProcessor;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.util.ClassUtil;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.apache.ibatis.logging.LogFactory;

public class DataSourceManager {
    private static DataSourceDecipher decipher;
    private static DataSourceProcessor dataSourceProcessor;
    private static DataSourceShardingStrategy dataSourceShardingStrategy;

    public static DataSourceDecipher getDecipher() {
        return decipher;
    }

    public static void setDecipher(DataSourceDecipher decipher) {
        DataSourceManager.decipher = decipher;
    }

    public static DataSourceProcessor getDataSourceProcessor() {
        return dataSourceProcessor;
    }

    public static void setDataSourceProcessor(DataSourceProcessor dataSourceProcessor) {
        DataSourceManager.dataSourceProcessor = dataSourceProcessor;
    }

    public static DataSourceShardingStrategy getDataSourceShardingStrategy() {
        return dataSourceShardingStrategy;
    }

    public static void setDataSourceShardingStrategy(DataSourceShardingStrategy dataSourceShardingStrategy) {
        DataSourceManager.dataSourceShardingStrategy = dataSourceShardingStrategy;
    }

    public static void decryptDataSource(DataSource dataSource) {
        if (decipher == null) {
            return;
        }
        try {
            DataSourceManager.restartDataSource(dataSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (DataSourceProperty property : DataSourceProperty.values()) {
            String value;
            Method getterMethod = ClassUtil.getAnyMethod(dataSource.getClass(), property.getGetterMethods());
            if (getterMethod == null || (value = DataSourceManager.invokeMethod(getterMethod, dataSource, new Object[0])) == null) continue;
            value = decipher.decrypt(property, value);
            Method setter = ClassUtil.getAnyMethod(dataSource.getClass(), property.getSetterMethods());
            if (setter == null || value == null) continue;
            DataSourceManager.invokeMethod(setter, dataSource, value);
        }
    }

    static void restartDataSource(DataSource dataSource) {
        Method restartMethod = ClassUtil.getFirstMethod(ClassUtil.getUsefulClass(dataSource.getClass()), method -> "restart".equals(method.getName()) && method.getParameterCount() == 0);
        if (restartMethod != null) {
            try {
                restartMethod.invoke((Object)dataSource, new Object[0]);
            }
            catch (Exception e) {
                throw FlexExceptions.wrap(e);
            }
        }
    }

    static String invokeMethod(Method method, Object object, Object ... params) {
        try {
            return (String)method.invoke(object, params);
        }
        catch (Exception e) {
            LogFactory.getLog(DataSourceManager.class).error("Can not invoke method: " + method.getName(), (Throwable)e);
            return null;
        }
    }

    static String processDataSourceKey(String dataSourceKey, Object targetOrProxy, Method method, Object[] arguments) {
        return dataSourceProcessor == null ? dataSourceKey : dataSourceProcessor.process(dataSourceKey, targetOrProxy, method, arguments);
    }

    static String getShardingDsKey(String dataSource, Object mapper, Method method, Object[] args) {
        return dataSourceShardingStrategy != null ? dataSourceShardingStrategy.doSharding(dataSource, mapper, method, args) : null;
    }
}

