/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.handler.BaseJsonTypeHandler;
import java.io.IOException;
import java.util.Collection;

public class JacksonTypeHandler
extends BaseJsonTypeHandler<Object> {
    private static ObjectMapper objectMapper;
    private final Class<?> propertyType;
    private Class<?> genericType;
    private JavaType javaType;

    public JacksonTypeHandler(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public JacksonTypeHandler(Class<?> propertyType, Class<?> genericType) {
        this.propertyType = propertyType;
        this.genericType = genericType;
    }

    @Override
    protected Object parseJson(String json) {
        try {
            if (this.genericType != null && Collection.class.isAssignableFrom(this.propertyType)) {
                return JacksonTypeHandler.getObjectMapper().readValue(json, this.getJavaType());
            }
            return JacksonTypeHandler.getObjectMapper().readValue(json, this.propertyType);
        }
        catch (IOException e) {
            throw FlexExceptions.wrap((Throwable)e, "Can not parseJson by JacksonTypeHandler: " + json, new Object[0]);
        }
    }

    @Override
    protected String toJson(Object object) {
        try {
            return JacksonTypeHandler.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw FlexExceptions.wrap((Throwable)e, "Can not convert object to Json by JacksonTypeHandler: " + object, new Object[0]);
        }
    }

    public JavaType getJavaType() {
        if (this.javaType == null) {
            this.javaType = JacksonTypeHandler.getObjectMapper().getTypeFactory().constructCollectionType(this.propertyType, this.genericType);
        }
        return this.javaType;
    }

    public static ObjectMapper getObjectMapper() {
        if (null == objectMapper) {
            objectMapper = new ObjectMapper();
        }
        return objectMapper;
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JacksonTypeHandler.objectMapper = objectMapper;
    }
}

