/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.optimisticlock;

import java.util.function.Supplier;

public class OptimisticLockManager {
    private static final ThreadLocal<Boolean> skipFlags = new ThreadLocal();

    private OptimisticLockManager() {
    }

    public static <T> T execWithoutOptimisticLock(Supplier<T> supplier) {
        try {
            OptimisticLockManager.skipOptimisticLock();
            T t = supplier.get();
            return t;
        }
        finally {
            OptimisticLockManager.restoreOptimisticLock();
        }
    }

    public static void execWithoutOptimisticLock(Runnable runnable) {
        try {
            OptimisticLockManager.skipOptimisticLock();
            runnable.run();
        }
        finally {
            OptimisticLockManager.restoreOptimisticLock();
        }
    }

    public static void skipOptimisticLock() {
        skipFlags.set(Boolean.TRUE);
    }

    public static void restoreOptimisticLock() {
        skipFlags.remove();
    }

    public static String getOptimisticLockColumn(String optimisticLockColumn) {
        if (optimisticLockColumn == null) {
            return null;
        }
        Boolean skipFlag = skipFlags.get();
        if (skipFlag == null) {
            return optimisticLockColumn;
        }
        return skipFlag != false ? null : optimisticLockColumn;
    }
}

