/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexAssert;
import com.mybatisflex.core.field.FieldQueryBuilder;
import com.mybatisflex.core.mybatis.MappedStatementTypes;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.provider.EntitySqlProvider;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.FunctionQueryColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.MapperUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public interface BaseMapper<T> {
    public static final int DEFAULT_BATCH_SIZE = 1000;

    default public int insert(T entity) {
        return this.insert(entity, false);
    }

    default public int insertSelective(T entity) {
        return this.insert(entity, true);
    }

    @InsertProvider(type=EntitySqlProvider.class, method="insert")
    public int insert(@Param(value="$$entity") T var1, @Param(value="$$ignoreNulls") boolean var2);

    default public int insertWithPk(T entity) {
        return this.insertWithPk(entity, false);
    }

    default public int insertSelectiveWithPk(T entity) {
        return this.insertWithPk(entity, true);
    }

    @InsertProvider(type=EntitySqlProvider.class, method="insertWithPk")
    public int insertWithPk(@Param(value="$$entity") T var1, @Param(value="$$ignoreNulls") boolean var2);

    @InsertProvider(type=EntitySqlProvider.class, method="insertBatch")
    public int insertBatch(@Param(value="$$entities") List<T> var1);

    default public int insertBatch(List<T> entities, int size) {
        if (size <= 0) {
            size = 1000;
        }
        int sum = 0;
        int entitiesSize = entities.size();
        int maxIndex = entitiesSize / size + (entitiesSize % size == 0 ? 0 : 1);
        for (int i = 0; i < maxIndex; ++i) {
            List<T> list = entities.subList(i * size, Math.min(i * size + size, entitiesSize));
            sum += this.insertBatch(list);
        }
        return sum;
    }

    default public int insertOrUpdate(T entity) {
        return this.insertOrUpdate(entity, false);
    }

    default public int insertOrUpdateSelective(T entity) {
        return this.insertOrUpdate(entity, true);
    }

    default public int insertOrUpdate(T entity, boolean ignoreNulls) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entity.getClass());
        Object[] pkArgs = tableInfo.buildPkSqlArgs(entity);
        if (pkArgs.length == 0 || pkArgs[0] == null) {
            return this.insert(entity, ignoreNulls);
        }
        return this.update(entity, ignoreNulls);
    }

    @DeleteProvider(type=EntitySqlProvider.class, method="deleteById")
    public int deleteById(@Param(value="$$primaryValue") Serializable var1);

    @DeleteProvider(type=EntitySqlProvider.class, method="deleteBatchByIds")
    public int deleteBatchByIds(@Param(value="$$primaryValue") Collection<? extends Serializable> var1);

    default public int deleteBatchByIds(List<? extends Serializable> ids, int size) {
        if (size <= 0) {
            size = 1000;
        }
        int sum = 0;
        int entitiesSize = ids.size();
        int maxIndex = entitiesSize / size + (entitiesSize % size == 0 ? 0 : 1);
        for (int i = 0; i < maxIndex; ++i) {
            List<? extends Serializable> list = ids.subList(i * size, Math.min(i * size + size, entitiesSize));
            sum += this.deleteBatchByIds(list);
        }
        return sum;
    }

    default public int deleteByMap(Map<String, Object> whereConditions) {
        FlexAssert.notEmpty(whereConditions, "whereConditions");
        return this.deleteByQuery(QueryWrapper.create().where(whereConditions));
    }

    default public int deleteByCondition(QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        return this.deleteByQuery(QueryWrapper.create().where(whereConditions));
    }

    @DeleteProvider(type=EntitySqlProvider.class, method="deleteByQuery")
    public int deleteByQuery(@Param(value="$$query") QueryWrapper var1);

    default public int update(T entity) {
        return this.update(entity, true);
    }

    @UpdateProvider(type=EntitySqlProvider.class, method="update")
    public int update(@Param(value="$$entity") T var1, @Param(value="$$ignoreNulls") boolean var2);

    default public int updateByMap(T entity, Map<String, Object> whereConditions) {
        FlexAssert.notEmpty(whereConditions, "whereConditions");
        return this.updateByQuery(entity, QueryWrapper.create().where(whereConditions));
    }

    default public int updateByMap(T entity, boolean ignoreNulls, Map<String, Object> whereConditions) {
        FlexAssert.notEmpty(whereConditions, "whereConditions");
        return this.updateByQuery(entity, ignoreNulls, QueryWrapper.create().where(whereConditions));
    }

    default public int updateByCondition(T entity, QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        return this.updateByQuery(entity, QueryWrapper.create().where(whereConditions));
    }

    default public int updateByCondition(T entity, boolean ignoreNulls, QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        return this.updateByQuery(entity, ignoreNulls, QueryWrapper.create().where(whereConditions));
    }

    default public int updateByQuery(T entity, QueryWrapper queryWrapper) {
        return this.updateByQuery(entity, true, queryWrapper);
    }

    @UpdateProvider(type=EntitySqlProvider.class, method="updateByQuery")
    public int updateByQuery(@Param(value="$$entity") T var1, @Param(value="$$ignoreNulls") boolean var2, @Param(value="$$query") QueryWrapper var3);

    @Deprecated
    @UpdateProvider(type=EntitySqlProvider.class, method="updateNumberAddByQuery")
    public int updateNumberAddByQuery(@Param(value="$$fieldName") String var1, @Param(value="$$value") Number var2, @Param(value="$$query") QueryWrapper var3);

    @Deprecated
    default public int updateNumberAddByQuery(QueryColumn column, Number value, QueryWrapper queryWrapper) {
        FlexAssert.notNull(value, "value");
        return this.updateNumberAddByQuery(column.getName(), value, queryWrapper);
    }

    @Deprecated
    default public int updateNumberAddByQuery(LambdaGetter<T> fn, Number value, QueryWrapper queryWrapper) {
        FlexAssert.notNull(value, "value");
        TableInfo tableInfo = TableInfoFactory.ofMapperClass(ClassUtil.getUsefulClass(this.getClass()));
        String column = tableInfo.getColumnByProperty(LambdaUtil.getFieldName(fn));
        return this.updateNumberAddByQuery(column, value, queryWrapper);
    }

    @SelectProvider(type=EntitySqlProvider.class, method="selectOneById")
    public T selectOneById(@Param(value="$$primaryValue") Serializable var1);

    default public T selectOneByMap(Map<String, Object> whereConditions) {
        FlexAssert.notEmpty(whereConditions, "whereConditions");
        return this.selectOneByQuery(QueryWrapper.create().where(whereConditions).limit(1L));
    }

    default public T selectOneByCondition(QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        return this.selectOneByQuery(QueryWrapper.create().where(whereConditions).limit(1L));
    }

    default public T selectOneByQuery(QueryWrapper queryWrapper) {
        return MapperUtil.getSelectOneResult(this.selectListByQuery(queryWrapper));
    }

    default public <R> R selectOneByQueryAs(QueryWrapper queryWrapper, Class<R> asType) {
        return MapperUtil.getSelectOneResult(this.selectListByQueryAs(queryWrapper, asType));
    }

    default public T selectOneWithRelationsByMap(Map<String, Object> whereConditions) {
        FlexAssert.notEmpty(whereConditions, "whereConditions");
        return this.selectOneWithRelationsByQuery(QueryWrapper.create().where(whereConditions).limit(1L));
    }

    default public T selectOneWithRelationsByCondition(QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        return this.selectOneWithRelationsByQuery(QueryWrapper.create().where(whereConditions).limit(1L));
    }

    default public T selectOneWithRelationsByQuery(QueryWrapper queryWrapper) {
        return MapperUtil.queryRelations(this, MapperUtil.getSelectOneResult(this.selectListByQuery(queryWrapper)));
    }

    default public T selectOneWithRelationsById(Serializable id) {
        return MapperUtil.queryRelations(this, this.selectOneById(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R selectOneWithRelationsByIdAs(Serializable id, Class<R> asType) {
        try {
            MappedStatementTypes.setCurrentType(asType);
            T t = this.selectOneWithRelationsById(id);
            return (R)t;
        }
        finally {
            MappedStatementTypes.clear();
        }
    }

    default public <R> R selectOneWithRelationsByQueryAs(QueryWrapper queryWrapper, Class<R> asType) {
        return MapperUtil.queryRelations(this, MapperUtil.getSelectOneResult(this.selectListByQueryAs(queryWrapper, asType)));
    }

    @SelectProvider(type=EntitySqlProvider.class, method="selectListByIds")
    public List<T> selectListByIds(@Param(value="$$primaryValue") Collection<? extends Serializable> var1);

    default public List<T> selectListByMap(Map<String, Object> whereConditions) {
        FlexAssert.notEmpty(whereConditions, "whereConditions");
        return this.selectListByQuery(QueryWrapper.create().where(whereConditions));
    }

    default public List<T> selectListByMap(Map<String, Object> whereConditions, Long count) {
        FlexAssert.notEmpty(whereConditions, "whereConditions");
        return this.selectListByQuery(QueryWrapper.create().where(whereConditions).limit(count));
    }

    default public List<T> selectListByCondition(QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        return this.selectListByQuery(QueryWrapper.create().where(whereConditions));
    }

    default public List<T> selectListByCondition(QueryCondition whereConditions, Long count) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        return this.selectListByQuery(QueryWrapper.create().where(whereConditions).limit(count));
    }

    @SelectProvider(type=EntitySqlProvider.class, method="selectListByQuery")
    public List<T> selectListByQuery(@Param(value="$$query") QueryWrapper var1);

    default public List<T> selectListByQuery(QueryWrapper queryWrapper, Consumer<FieldQueryBuilder<T>> ... consumers) {
        List<T> list = this.selectListByQuery(queryWrapper);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        MapperUtil.queryFields(this, list, consumers);
        return list;
    }

    @SelectProvider(type=EntitySqlProvider.class, method="selectListByQuery")
    public Cursor<T> selectCursorByQuery(@Param(value="$$query") QueryWrapper var1);

    @SelectProvider(type=EntitySqlProvider.class, method="selectListByQuery")
    public List<Row> selectRowsByQuery(@Param(value="$$query") QueryWrapper var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> List<R> selectListByQueryAs(QueryWrapper queryWrapper, Class<R> asType) {
        if (Number.class.isAssignableFrom(asType) || String.class == asType) {
            return this.selectObjectListByQueryAs(queryWrapper, asType);
        }
        if (Map.class.isAssignableFrom(asType)) {
            return this.selectRowsByQuery(queryWrapper);
        }
        try {
            MappedStatementTypes.setCurrentType(asType);
            List<T> list = this.selectListByQuery(queryWrapper);
            return list;
        }
        finally {
            MappedStatementTypes.clear();
        }
    }

    default public <R> List<R> selectListByQueryAs(QueryWrapper queryWrapper, Class<R> asType, Consumer<FieldQueryBuilder<R>> ... consumers) {
        List<R> list = this.selectListByQueryAs(queryWrapper, asType);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        MapperUtil.queryFields(this, list, consumers);
        return list;
    }

    default public List<T> selectListWithRelationsByQuery(QueryWrapper queryWrapper) {
        return MapperUtil.queryRelations(this, this.selectListByQuery(queryWrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> List<R> selectListWithRelationsByQueryAs(QueryWrapper queryWrapper, Class<R> asType) {
        List<T> result;
        if (Number.class.isAssignableFrom(asType) || String.class == asType) {
            return this.selectObjectListByQueryAs(queryWrapper, asType);
        }
        if (Map.class.isAssignableFrom(asType)) {
            return this.selectRowsByQuery(queryWrapper);
        }
        try {
            MappedStatementTypes.setCurrentType(asType);
            result = this.selectListByQuery(queryWrapper);
        }
        finally {
            MappedStatementTypes.clear();
        }
        return MapperUtil.queryRelations(this, result);
    }

    default public <R> List<R> selectListWithRelationsByQueryAs(QueryWrapper queryWrapper, Class<R> asType, Consumer<FieldQueryBuilder<R>> ... consumers) {
        List<R> list = this.selectListByQueryAs(queryWrapper, asType);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        MapperUtil.queryRelations(this, list);
        MapperUtil.queryFields(this, list, consumers);
        return list;
    }

    default public List<T> selectAll() {
        return this.selectListByQuery(new QueryWrapper());
    }

    default public List<T> selectAllWithRelations() {
        return MapperUtil.queryRelations(this, this.selectListByQuery(new QueryWrapper()));
    }

    default public Object selectObjectByQuery(QueryWrapper queryWrapper) {
        return MapperUtil.getSelectOneResult(this.selectObjectListByQuery(queryWrapper));
    }

    default public <R> R selectObjectByQueryAs(QueryWrapper queryWrapper, Class<R> asType) {
        return MapperUtil.getSelectOneResult(this.selectObjectListByQueryAs(queryWrapper, asType));
    }

    @SelectProvider(type=EntitySqlProvider.class, method="selectObjectByQuery")
    public List<Object> selectObjectListByQuery(@Param(value="$$query") QueryWrapper var1);

    default public <R> List<R> selectObjectListByQueryAs(QueryWrapper queryWrapper, Class<R> asType) {
        List<Object> queryResults = this.selectObjectListByQuery(queryWrapper);
        if (queryResults == null || queryResults.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>(queryResults.size());
        for (Object queryResult : queryResults) {
            results.add(ConvertUtil.convert(queryResult, asType));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public long selectCountByQuery(QueryWrapper queryWrapper) {
        List<QueryColumn> selectColumns = CPI.getSelectColumns(queryWrapper);
        try {
            List<Object> objects;
            if (CollectionUtil.isEmpty(selectColumns)) {
                queryWrapper.select(QueryMethods.count());
                objects = this.selectObjectListByQuery(queryWrapper);
            } else if (selectColumns.get(0) instanceof FunctionQueryColumn) {
                if (!"COUNT".equalsIgnoreCase(((FunctionQueryColumn)selectColumns.get(0)).getFnName())) {
                    queryWrapper.select(QueryMethods.count());
                }
                objects = this.selectObjectListByQuery(queryWrapper);
            } else if (MapperUtil.hasDistinct(selectColumns)) {
                objects = this.selectObjectListByQuery(MapperUtil.rawCountQueryWrapper(queryWrapper));
            } else {
                queryWrapper.select(QueryMethods.count());
                objects = this.selectObjectListByQuery(queryWrapper);
            }
            long l = MapperUtil.getLongNumber(objects);
            return l;
        }
        finally {
            CPI.setSelectColumns(queryWrapper, selectColumns);
        }
    }

    default public long selectCountByCondition(QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        return this.selectCountByQuery(QueryWrapper.create().where(whereConditions));
    }

    default public Page<T> paginate(Number pageNumber, Number pageSize, QueryWrapper queryWrapper) {
        Page page = new Page(pageNumber, pageSize);
        return this.paginate(page, queryWrapper);
    }

    default public Page<T> paginateWithRelations(Number pageNumber, Number pageSize, QueryWrapper queryWrapper) {
        Page page = new Page(pageNumber, pageSize);
        return this.paginateWithRelations(page, queryWrapper);
    }

    default public Page<T> paginate(Number pageNumber, Number pageSize, QueryCondition whereConditions) {
        Page page = new Page(pageNumber, pageSize);
        return this.paginate(page, new QueryWrapper().where(whereConditions));
    }

    default public Page<T> paginateWithRelations(Number pageNumber, Number pageSize, QueryCondition whereConditions) {
        Page page = new Page(pageNumber, pageSize);
        return this.paginateWithRelations(page, new QueryWrapper().where(whereConditions));
    }

    default public Page<T> paginate(Number pageNumber, Number pageSize, Number totalRow, QueryWrapper queryWrapper) {
        Page page = new Page(pageNumber, pageSize, totalRow);
        return this.paginate(page, queryWrapper);
    }

    default public Page<T> paginateWithRelations(Number pageNumber, Number pageSize, Number totalRow, QueryWrapper queryWrapper) {
        Page page = new Page(pageNumber, pageSize, totalRow);
        return this.paginateWithRelations(page, queryWrapper);
    }

    default public Page<T> paginate(Number pageNumber, Number pageSize, Number totalRow, QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        Page page = new Page(pageNumber, pageSize, totalRow);
        return this.paginate(page, new QueryWrapper().where(whereConditions));
    }

    default public Page<T> paginateWithRelations(Number pageNumber, Number pageSize, Number totalRow, QueryCondition whereConditions) {
        FlexAssert.notNull(whereConditions, "whereConditions");
        Page page = new Page(pageNumber, pageSize, totalRow);
        return this.paginateWithRelations(page, new QueryWrapper().where(whereConditions));
    }

    default public Page<T> paginate(Page<T> page, QueryWrapper queryWrapper) {
        return this.paginateAs(page, queryWrapper, null);
    }

    default public Page<T> paginate(Page<T> page, QueryWrapper queryWrapper, Consumer<FieldQueryBuilder<T>> ... consumers) {
        return this.paginateAs(page, queryWrapper, null, consumers);
    }

    default public Page<T> paginateWithRelations(Page<T> page, QueryWrapper queryWrapper) {
        return this.paginateWithRelationsAs(page, queryWrapper, null);
    }

    default public Page<T> paginateWithRelations(Page<T> page, QueryWrapper queryWrapper, Consumer<FieldQueryBuilder<T>> ... consumers) {
        return this.paginateWithRelationsAs(page, queryWrapper, null, consumers);
    }

    default public <R> Page<R> paginateAs(Number pageNumber, Number pageSize, QueryWrapper queryWrapper, Class<R> asType) {
        Page page = new Page(pageNumber, pageSize);
        return MapperUtil.doPaginate(this, page, queryWrapper, asType, false, new Consumer[0]);
    }

    default public <R> Page<R> paginateAs(Number pageNumber, Number pageSize, Number totalRow, QueryWrapper queryWrapper, Class<R> asType) {
        Page page = new Page(pageNumber, pageSize, totalRow);
        return MapperUtil.doPaginate(this, page, queryWrapper, asType, false, new Consumer[0]);
    }

    default public <R> Page<R> paginateAs(Page<R> page, QueryWrapper queryWrapper, Class<R> asType) {
        return MapperUtil.doPaginate(this, page, queryWrapper, asType, false, new Consumer[0]);
    }

    default public <R> Page<R> paginateAs(Page<R> page, QueryWrapper queryWrapper, Class<R> asType, Consumer<FieldQueryBuilder<R>> ... consumers) {
        return MapperUtil.doPaginate(this, page, queryWrapper, asType, false, consumers);
    }

    default public <R> Page<R> paginateWithRelationsAs(Number pageNumber, Number pageSize, QueryWrapper queryWrapper, Class<R> asType) {
        Page page = new Page(pageNumber, pageSize);
        return MapperUtil.doPaginate(this, page, queryWrapper, asType, true, new Consumer[0]);
    }

    default public <R> Page<R> paginateWithRelationsAs(Number pageNumber, Number pageSize, Number totalRow, QueryWrapper queryWrapper, Class<R> asType) {
        Page page = new Page(pageNumber, pageSize, totalRow);
        return MapperUtil.doPaginate(this, page, queryWrapper, asType, true, new Consumer[0]);
    }

    default public <R> Page<R> paginateWithRelationsAs(Page<R> page, QueryWrapper queryWrapper, Class<R> asType) {
        return MapperUtil.doPaginate(this, page, queryWrapper, asType, true, new Consumer[0]);
    }

    default public <R> Page<R> paginateWithRelationsAs(Page<R> page, QueryWrapper queryWrapper, Class<R> asType, Consumer<FieldQueryBuilder<R>> ... consumers) {
        return MapperUtil.doPaginate(this, page, queryWrapper, asType, true, consumers);
    }

    default public <E> Page<E> xmlPaginate(String dataSelectId, Page<E> page, QueryWrapper queryWrapper) {
        return this.xmlPaginate(dataSelectId, dataSelectId + "_COUNT", page, queryWrapper, null);
    }

    default public <E> Page<E> xmlPaginate(String dataSelectId, Page<E> page, Map<String, Object> otherParams) {
        return this.xmlPaginate(dataSelectId, dataSelectId + "_COUNT", page, null, otherParams);
    }

    default public <E> Page<E> xmlPaginate(String dataSelectId, Page<E> page, QueryWrapper queryWrapper, Map<String, Object> otherParams) {
        return this.xmlPaginate(dataSelectId, dataSelectId + "_COUNT", page, queryWrapper, otherParams);
    }

    default public <E> Page<E> xmlPaginate(String dataSelectId, String countSelectId, Page<E> page, QueryWrapper queryWrapper, Map<String, Object> otherParams) {
        SqlSessionFactory sqlSessionFactory = FlexGlobalConfig.getDefaultConfig().getSqlSessionFactory();
        ExecutorType executorType = FlexGlobalConfig.getDefaultConfig().getConfiguration().getDefaultExecutorType();
        String mapperClassName = ClassUtil.getUsefulClass(this.getClass()).getName();
        Map<String, Object> preparedParams = MapperUtil.preparedParams(page, queryWrapper, otherParams);
        if (!dataSelectId.contains(".")) {
            dataSelectId = mapperClassName + "." + dataSelectId;
        }
        try (SqlSession sqlSession = sqlSessionFactory.openSession(executorType, false);){
            if (page.getTotalRow() < 0L) {
                if (!countSelectId.contains(".")) {
                    countSelectId = mapperClassName + "." + countSelectId;
                }
                Number number = (Number)sqlSession.selectOne(countSelectId, preparedParams);
                page.setTotalRow(number);
            }
            if (!page.isEmpty()) {
                List entities = sqlSession.selectList(dataSelectId, preparedParams);
                page.setRecords(entities);
            }
        }
        return page;
    }
}

