/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.activerecord.query;

import com.mybatisflex.core.activerecord.Model;
import com.mybatisflex.core.activerecord.query.AbstractQuery;
import com.mybatisflex.core.field.FieldQuery;
import com.mybatisflex.core.field.FieldQueryManager;
import com.mybatisflex.core.field.QueryBuilder;
import com.mybatisflex.core.mybatis.MappedStatementTypes;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.util.FieldWrapper;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldsQuery<T extends Model<T>>
extends AbstractQuery<T> {
    private final Map<String, FieldQuery> fieldQueryMap = new HashMap<String, FieldQuery>();

    public FieldsQuery(Model<T> model) {
        super(model);
    }

    public <F> FieldsQuery<T> fieldMapping(LambdaGetter<F> field, QueryBuilder<F> builder) {
        return this.fieldMapping(field, false, builder);
    }

    public <F> FieldsQuery<T> fieldMapping(LambdaGetter<F> field, boolean prevent, QueryBuilder<F> builder) {
        String fieldName = LambdaUtil.getFieldName(field);
        Class<?> entityClass = LambdaUtil.getImplClass(field);
        FieldQuery fieldQuery = new FieldQuery();
        fieldQuery.setPrevent(prevent);
        fieldQuery.setFieldName(fieldName);
        fieldQuery.setQueryBuilder(builder);
        fieldQuery.setEntityClass(entityClass);
        fieldQuery.setFieldWrapper(FieldWrapper.of(entityClass, fieldName));
        this.fieldQueryMap.put(entityClass.getName() + '#' + fieldName, fieldQuery);
        return this;
    }

    @Override
    public T oneById() {
        List entities = Collections.singletonList(this.baseMapper().selectOneById((Serializable)this.pkValues()));
        FieldQueryManager.queryFields(this.baseMapper(), entities, this.fieldQueryMap);
        return (T)((Model)entities.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R oneByIdAs(Class<R> asType) {
        try {
            MappedStatementTypes.setCurrentType(asType);
            List entities = Collections.singletonList(this.baseMapper().selectOneById((Serializable)this.pkValues()));
            FieldQueryManager.queryFields(this.baseMapper(), entities, this.fieldQueryMap);
            Object t = entities.get(0);
            return (R)t;
        }
        finally {
            MappedStatementTypes.clear();
        }
    }

    @Override
    public T one() {
        List entities = Collections.singletonList(this.baseMapper().selectOneByQuery(this.queryWrapper()));
        FieldQueryManager.queryFields(this.baseMapper(), entities, this.fieldQueryMap);
        return (T)((Model)entities.get(0));
    }

    @Override
    public <R> R oneAs(Class<R> asType) {
        List<R> entities = Collections.singletonList(this.baseMapper().selectOneByQueryAs(this.queryWrapper(), asType));
        FieldQueryManager.queryFields(this.baseMapper(), entities, this.fieldQueryMap);
        return entities.get(0);
    }

    @Override
    public List<T> list() {
        List entities = this.baseMapper().selectListByQuery(this.queryWrapper());
        FieldQueryManager.queryFields(this.baseMapper(), entities, this.fieldQueryMap);
        return entities;
    }

    @Override
    public <R> List<R> listAs(Class<R> asType) {
        List<R> entities = this.baseMapper().selectListByQueryAs(this.queryWrapper(), asType);
        FieldQueryManager.queryFields(this.baseMapper(), entities, this.fieldQueryMap);
        return entities;
    }

    @Override
    public Page<T> page(Page<T> page) {
        this.baseMapper().paginate(page, this.queryWrapper());
        FieldQueryManager.queryFields(this.baseMapper(), page.getRecords(), this.fieldQueryMap);
        return page;
    }

    @Override
    public <R> Page<R> pageAs(Page<R> page, Class<R> asType) {
        this.baseMapper().paginateAs(page, this.queryWrapper(), asType);
        FieldQueryManager.queryFields(this.baseMapper(), page.getRecords(), this.fieldQueryMap);
        return page;
    }
}

