/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.exception;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.exception.locale.LocalizedFormats;
import java.util.Collection;
import java.util.Map;

public final class FlexAssert {
    private FlexAssert() {
    }

    public static void notNull(Object obj, String param) {
        if (obj == null) {
            throw FlexExceptions.wrap(LocalizedFormats.OBJECT_NULL, param);
        }
    }

    public static void notEmpty(Map<?, ?> map, String param) {
        if (map == null || map.isEmpty()) {
            throw FlexExceptions.wrap(LocalizedFormats.MAP_NULL_OR_EMPTY, param);
        }
    }

    public static void notEmpty(Collection<?> collection, String param) {
        if (collection == null || collection.isEmpty()) {
            throw FlexExceptions.wrap(LocalizedFormats.MAP_NULL_OR_EMPTY, param);
        }
    }

    public static <T> void notEmpty(T[] array, String param) {
        if (array == null || array.length == 0) {
            throw FlexExceptions.wrap(param, new Object[0]);
        }
    }

    public static <T> void assertAreNotNull(T[] elements, String msg, Object params) {
        if (elements == null || elements.length == 0) {
            throw FlexExceptions.wrap(msg, params);
        }
        for (T element : elements) {
            if (element != null) continue;
            throw FlexExceptions.wrap(msg, params);
        }
    }
}

