/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryWrapperAdapter;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.SqlUtil;
import java.util.List;
import java.util.Optional;

public class QueryChain<T>
extends QueryWrapperAdapter<QueryChain<T>> {
    private final BaseMapper<T> baseMapper;

    public QueryChain(BaseMapper<T> baseMapper) {
        this.baseMapper = baseMapper;
    }

    public static <E> QueryChain<E> of(BaseMapper<E> baseMapper) {
        return new QueryChain<E>(baseMapper);
    }

    public long count() {
        return this.baseMapper.selectCountByQuery(this);
    }

    public boolean exists() {
        return SqlUtil.toBool(this.count());
    }

    public T one() {
        return this.baseMapper.selectOneByQuery(this);
    }

    public <R> R oneAs(Class<R> asType) {
        return this.baseMapper.selectOneByQueryAs(this, asType);
    }

    public T oneWithRelations() {
        return this.baseMapper.selectOneWithRelationsByQuery(this);
    }

    public <R> R oneWithRelationsAs(Class<R> asType) {
        return this.baseMapper.selectOneWithRelationsByQueryAs(this, asType);
    }

    public Optional<T> oneOpt() {
        return Optional.ofNullable(this.baseMapper.selectOneByQuery(this));
    }

    public <R> Optional<R> oneAsOpt(Class<R> asType) {
        return Optional.ofNullable(this.baseMapper.selectOneByQueryAs(this, asType));
    }

    public Optional<T> oneWithRelationsOpt() {
        return Optional.ofNullable(this.baseMapper.selectOneWithRelationsByQuery(this));
    }

    public <R> Optional<R> oneWithRelationsAsOpt(Class<R> asType) {
        return Optional.ofNullable(this.baseMapper.selectOneWithRelationsByQueryAs(this, asType));
    }

    public Object obj() {
        return this.baseMapper.selectObjectByQuery(this);
    }

    public <R> R objAs(Class<R> asType) {
        return this.baseMapper.selectObjectByQueryAs(this, asType);
    }

    public Optional<Object> objOpt() {
        return Optional.ofNullable(this.baseMapper.selectObjectByQuery(this));
    }

    public <R> Optional<R> objAsOpt(Class<R> asType) {
        return Optional.ofNullable(this.baseMapper.selectObjectByQueryAs(this, asType));
    }

    public List<Object> objList() {
        return this.baseMapper.selectObjectListByQuery(this);
    }

    public <R> List<R> objListAs(Class<R> asType) {
        return this.baseMapper.selectObjectListByQueryAs(this, asType);
    }

    public List<T> list() {
        return this.baseMapper.selectListByQuery(this);
    }

    public List<T> listWithRelations() {
        return this.baseMapper.selectListWithRelationsByQuery(this);
    }

    public <R> List<R> listAs(Class<R> asType) {
        return this.baseMapper.selectListByQueryAs(this, asType);
    }

    public <R> List<R> listWithRelationsAs(Class<R> asType) {
        return this.baseMapper.selectListWithRelationsByQueryAs(this, asType);
    }

    public Page<T> page(Page<T> page) {
        return this.baseMapper.paginate(page, this);
    }

    public Page<T> pageWithRelations(Page<T> page) {
        return this.baseMapper.paginateWithRelations(page, this);
    }

    public <R> Page<R> pageAs(Page<R> page, Class<R> asType) {
        return this.baseMapper.paginateAs(page, this, asType);
    }

    public <R> Page<R> pageWithRelationsAs(Page<R> page, Class<R> asType) {
        return this.baseMapper.paginateWithRelationsAs(page, this, asType);
    }

    @Override
    public String toSQL() {
        TableInfo tableInfo = TableInfoFactory.ofMapperClass(this.baseMapper.getClass());
        CPI.setFromIfNecessary(this, tableInfo.getSchema(), tableInfo.getTableName());
        return super.toSQL();
    }
}

